/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.authorization;

import cn.bbwres.biscuit.entity.UserBaseInfo;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.CollectionUtils;

public class MapAuthentication
implements Authentication {
    private static final long serialVersionUID = -6852083236246571439L;
    private Collection<GrantedAuthority> authorities;
    private String userId;
    private String zhName;
    private String username;
    private String tenantId;
    private String clientId;
    private Object principal;
    private boolean authenticated;

    public MapAuthentication(UserBaseInfo userBaseInfo) {
        if (ObjectUtils.isEmpty((Object)userBaseInfo)) {
            this.authenticated = false;
            return;
        }
        this.username = userBaseInfo.getUsername();
        this.zhName = userBaseInfo.getZhName();
        this.clientId = userBaseInfo.getClientId();
        this.principal = userBaseInfo.getUserInfo();
        this.userId = userBaseInfo.getUserId();
        this.tenantId = userBaseInfo.getTenantId();
        this.authenticated = true;
        if (!CollectionUtils.isEmpty((Collection)userBaseInfo.getAuthorities())) {
            this.authorities = userBaseInfo.getAuthorities().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        }
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return null;
    }

    public Object getDetails() {
        return null;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        this.authenticated = isAuthenticated;
    }

    public String getName() {
        return this.username;
    }

    public void setAuthorities(Collection<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public void setPrincipal(Object principal) {
        this.principal = principal;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getZhName() {
        return this.zhName;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }
}

