/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.authorization;

import cn.bbwres.biscuit.gateway.authorization.MapAuthentication;
import cn.bbwres.biscuit.gateway.cache.ResourceCacheService;
import cn.bbwres.biscuit.gateway.utils.AuthUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import reactor.core.publisher.Mono;

public class AuthorizationManager
implements ReactiveAuthorizationManager<AuthorizationContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthorizationManager.class);
    private final ResourceCacheService resourceCacheService;
    private final PathMatcher pathMatcher;

    public Mono<AuthorizationDecision> check(Mono<Authentication> mono, AuthorizationContext authorizationContext) {
        ServerHttpRequest request = authorizationContext.getExchange().getRequest();
        String path = request.getURI().getPath();
        String requestMethod = request.getMethod().toString();
        Mono resourceMono = mono.filter(Authentication::isAuthenticated).flatMap(authentication -> {
            Mono<List<String>> loginAuthResource = this.resourceCacheService.getLoginAuthResource();
            Set<String> roles = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
            if (authentication instanceof MapAuthentication) {
                MapAuthentication mapAuthentication = (MapAuthentication)authentication;
                mapAuthentication.setAuthorities(null);
            }
            authorizationContext.getExchange().getAttributes().put("USER_INFO", authentication);
            return loginAuthResource.switchIfEmpty(Mono.just(new ArrayList(0))).zipWith(this.resourceCacheService.getResourceByRole(roles).switchIfEmpty(Mono.just(new ArrayList(0)))).map(objects -> {
                List t2;
                HashSet resources = new HashSet();
                List t1 = (List)objects.getT1();
                if (!CollectionUtils.isEmpty((Collection)t1)) {
                    resources.addAll(t1);
                }
                if (!CollectionUtils.isEmpty((Collection)(t2 = (List)objects.getT2()))) {
                    resources.addAll(t2);
                }
                return resources;
            });
        });
        return resourceMono.map(resources -> AuthUtils.checkAuth(resources, requestMethod, path, this.pathMatcher)).map(AuthorizationDecision::new).defaultIfEmpty((Object)new AuthorizationDecision(false));
    }

    @Generated
    public AuthorizationManager(ResourceCacheService resourceCacheService, PathMatcher pathMatcher) {
        this.resourceCacheService = resourceCacheService;
        this.pathMatcher = pathMatcher;
    }
}

