/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway;

import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.adapter.ErrorWebExceptionHandler;
import cn.bbwres.biscuit.gateway.adapter.ExtensionErrorAttributes;
import cn.bbwres.biscuit.gateway.route.DefaultGatewayRoute;
import cn.bbwres.biscuit.gateway.route.GatewayRouteNacosProcessor;
import cn.bbwres.biscuit.gateway.route.RouterController;
import cn.bbwres.biscuit.nacos.operation.NacosConfigOperation;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionWriter;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.codec.Encoder;
import org.springframework.core.env.Environment;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.session.CookieWebSessionIdResolver;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.WebSessionIdResolver;
import org.springframework.web.server.session.WebSessionManager;

@AutoConfiguration
@EnableConfigurationProperties(value={GatewayProperties.class})
public class GatewayAutoConfigure {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GatewayAutoConfigure.class);

    @Bean
    public ExtensionErrorAttributes errorAttributes(GatewayProperties gatewayProperties, ObjectProvider<MessageSourceAccessor> messagesProvider) {
        return new ExtensionErrorAttributes(gatewayProperties, (MessageSourceAccessor)messagesProvider.getIfAvailable());
    }

    @Bean
    public ErrorWebExceptionHandler errorWebExceptionHandler(ErrorAttributes errorAttributes, WebProperties webProperties, ApplicationContext applicationContext) {
        ErrorWebExceptionHandler errorWebExceptionHandler = new ErrorWebExceptionHandler(errorAttributes, webProperties.getResources(), applicationContext);
        errorWebExceptionHandler.setMessageWriters(List.of(new EncoderHttpMessageWriter((Encoder)new Jackson2JsonEncoder())));
        return errorWebExceptionHandler;
    }

    @Bean
    @ConditionalOnProperty(prefix="biscuit.gateway", name={"session"}, havingValue="false", matchIfMissing=true)
    public WebSessionManager webSessionManager() {
        DefaultWebSessionManager defaultWebSessionManager = new DefaultWebSessionManager();
        defaultWebSessionManager.setSessionIdResolver((WebSessionIdResolver)new CookieWebSessionIdResolver(this){

            public void expireSession(ServerWebExchange exchange) {
            }
        });
        return defaultWebSessionManager;
    }

    @Bean
    public RouterController routerController(RouteLocator routeLocator) {
        return new RouterController(routeLocator);
    }

    @Configuration
    @ConditionalOnProperty(prefix="biscuit.gateway", name={"dynamic-route-enabled"}, havingValue="true", matchIfMissing=true)
    protected static class DynamicRouteConfigurer {
        protected DynamicRouteConfigurer() {
        }

        @Bean
        public DefaultGatewayRoute defaultGatewayRoute(RouteDefinitionLocator routeDefinitionLocator, RouteDefinitionWriter routeDefinitionWriter, org.springframework.cloud.gateway.config.GatewayProperties gatewayProperties) {
            return new DefaultGatewayRoute(routeDefinitionLocator, routeDefinitionWriter, gatewayProperties);
        }

        @ConditionalOnClass(value={NacosConfigOperation.class})
        @Configuration
        protected static class DynamicRouteNacosConfigurer {
            protected DynamicRouteNacosConfigurer() {
            }

            @Bean
            public GatewayRouteNacosProcessor gatewayRouteNacosProcessor(NacosConfigOperation nacosConfigOperation, DefaultGatewayRoute defaultGatewayRoute, GatewayProperties gatewayProperties, Environment environment) {
                return new GatewayRouteNacosProcessor(nacosConfigOperation, defaultGatewayRoute, gatewayProperties, environment);
            }
        }
    }
}

