/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.filters;

import cn.bbwres.biscuit.gateway.GatewayProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AuthFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    private final GatewayProperties gatewayProperties;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        Object userInfo;
        log.debug("\u5904\u7406\u7528\u6237\u8ba4\u8bc1\u53c2\u6570\u4fe1\u606f");
        exchange = this.removeHeaders(exchange, this.gatewayProperties.getUserTokenHeader(), this.gatewayProperties.getUserInfoHeader());
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpRequest.Builder builder = request.mutate();
        Object userToken = exchange.getAttributes().get("USER_TOKEN");
        if (Objects.nonNull(userToken)) {
            builder.header(this.gatewayProperties.getUserTokenHeader(), new String[]{userToken.toString()});
        }
        if (Objects.nonNull(userInfo = exchange.getAttributes().get("USER_INFO"))) {
            builder.header(this.gatewayProperties.getUserInfoHeader(), new String[]{userInfo.toString()});
        }
        return chain.filter(exchange.mutate().request(request).build());
    }

    private ServerWebExchange removeHeaders(ServerWebExchange exchange, String ... headers) {
        if (ArrayUtils.isEmpty((Object[])headers)) {
            return exchange;
        }
        List headerList = Arrays.stream(headers).filter(header -> exchange.getRequest().getHeaders().containsKey(header)).collect(Collectors.toList());
        ServerHttpRequest request = exchange.getRequest().mutate().headers(httpHeaders -> {
            for (String hh : headerList) {
                httpHeaders.remove((Object)hh);
            }
        }).build();
        return exchange.mutate().request(request).build();
    }

    public int getOrder() {
        return 9002;
    }

    public AuthFilter(GatewayProperties gatewayProperties) {
        this.gatewayProperties = gatewayProperties;
    }
}

