/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.cache;

import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.service.ResourceService;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;

public class ResourceCacheService {
    public static final String LOGIN_AUTH_RESOURCE = "LOGIN_AUTH_RESOURCE";
    private LoadingCache<String, List<String>> resourceNoUserCache;
    private LoadingCache<String, List<String>> resourceRoleCache;
    private final GatewayProperties gatewayProperties;
    private final ResourceService resourceService;

    public ResourceCacheService(GatewayProperties gatewayProperties, ResourceService resourceService) {
        this.gatewayProperties = gatewayProperties;
        this.resourceService = resourceService;
    }

    @PostConstruct
    public void init() {
        if (this.gatewayProperties.getCacheResource().booleanValue()) {
            this.resourceNoUserCache = Caffeine.newBuilder().expireAfterWrite((long)this.gatewayProperties.getLocalCacheResourceTime().intValue(), TimeUnit.SECONDS).maximumSize(10L).build(key -> this.resourceService.getLoginAuthResource());
            this.resourceRoleCache = Caffeine.newBuilder().expireAfterWrite((long)this.gatewayProperties.getLocalCacheResourceTime().intValue(), TimeUnit.SECONDS).maximumSize(2000L).build(this.resourceService::getResourceByRole);
        }
    }

    public List<String> getLoginAuthResource() {
        if (this.gatewayProperties.getCacheResource().booleanValue()) {
            return (List)this.resourceNoUserCache.get((Object)LOGIN_AUTH_RESOURCE);
        }
        return this.resourceService.getLoginAuthResource();
    }

    public List<String> getResourceByRole(String roleId) {
        if (this.gatewayProperties.getCacheResource().booleanValue()) {
            return (List)this.resourceRoleCache.get((Object)roleId);
        }
        return this.resourceService.getResourceByRole(roleId);
    }

    public String getLoginUrlBuildState(String state) {
        return this.resourceService.getLoginUrlBuildState(state);
    }
}

