/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.authorization;

import cn.bbwres.biscuit.gateway.authorization.MapAuthentication;
import cn.bbwres.biscuit.gateway.service.ResourceService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import reactor.core.publisher.Mono;

@AutoConfiguration
public class TokenConfig {
    private static final Logger log = LoggerFactory.getLogger(TokenConfig.class);

    @Bean
    public ReactiveAuthenticationManager jwtReactiveAuthenticationManager(final ResourceService resourceService) {
        return new ReactiveAuthenticationManager(){

            public Mono<Authentication> authenticate(Authentication authentication) {
                return Mono.justOrEmpty((Object)authentication).filter(a -> a instanceof BearerTokenAuthenticationToken).cast(BearerTokenAuthenticationToken.class).map(BearerTokenAuthenticationToken::getToken).flatMap(this::makeRequest).flatMap(this::parseToken).cast(Authentication.class).onErrorMap(JwtException.class, this::onError);
            }

            private Mono<Map<String, Object>> makeRequest(String token) {
                return Mono.justOrEmpty(resourceService.checkToken(token));
            }

            private Mono<MapAuthentication> parseToken(Map<String, Object> claims) {
                return Mono.justOrEmpty((Object)new MapAuthentication(claims));
            }

            private AuthenticationException onError(JwtException ex) {
                if (ex instanceof BadJwtException) {
                    return new InvalidBearerTokenException(ex.getMessage(), (Throwable)ex);
                }
                return new AuthenticationServiceException(ex.getMessage(), (Throwable)ex);
            }
        };
    }

    @Bean
    public ReactiveOpaqueTokenIntrospector reactiveOpaqueTokenIntrospector(final ResourceService resourceService) {
        return new ReactiveOpaqueTokenIntrospector(){

            public Mono<OAuth2AuthenticatedPrincipal> introspect(String token) {
                return Mono.just((Object)token).flatMap(this::makeRequest).map(this::convertClaimsSet).onErrorMap(e -> !(e instanceof OAuth2IntrospectionException), ex -> new OAuth2IntrospectionException(ex.getMessage(), ex));
            }

            private OAuth2AuthenticatedPrincipal convertClaimsSet(Map<String, Object> claims) {
                claims.computeIfPresent("aud", (k, v) -> {
                    if (v instanceof String) {
                        return Collections.singletonList(v);
                    }
                    return v;
                });
                claims.computeIfPresent("client_id", (k, v) -> v.toString());
                claims.computeIfPresent("exp", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
                claims.computeIfPresent("iat", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
                claims.computeIfPresent("iss", (k, v) -> v.toString());
                claims.computeIfPresent("nbf", (k, v) -> Instant.ofEpochSecond(((Number)v).longValue()));
                ArrayList authorities = new ArrayList();
                claims.computeIfPresent("scope", (k, v) -> {
                    if (v instanceof String) {
                        List<String> scopes = Arrays.asList(((String)v).split(" "));
                        for (String scope : scopes) {
                            authorities.add(new SimpleGrantedAuthority(scope));
                        }
                        return scopes;
                    }
                    return v;
                });
                return new OAuth2IntrospectionAuthenticatedPrincipal(claims, authorities);
            }

            private Mono<Map<String, Object>> makeRequest(String token) {
                return Mono.justOrEmpty(resourceService.checkToken(token));
            }
        };
    }
}

