/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.authorization;

import cn.bbwres.biscuit.dto.Result;
import cn.bbwres.biscuit.gateway.GatewayProperties;
import cn.bbwres.biscuit.gateway.authorization.AuthorizationManager;
import cn.bbwres.biscuit.utils.JsonUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.oauth2.server.resource.introspection.ReactiveOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.server.ServerBearerTokenAuthenticationConverter;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

@AutoConfiguration
@EnableConfigurationProperties(value={GatewayProperties.class})
public class ResourceServerConfig {
    private static final Logger log = LoggerFactory.getLogger(ResourceServerConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new HttpMessageConverters((Collection)converters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http, GatewayProperties gatewayProperties, AuthorizationManager authorizationManager, ServerAccessDeniedHandler customServerAccessDeniedHandler, ServerAuthenticationEntryPoint customServerAuthenticationEntryPoint, ReactiveAuthenticationManager jwtReactiveAuthenticationManager, ObjectProvider<ReactiveOpaqueTokenIntrospector> reactiveOpaqueTokenIntrospector) {
        ServerHttpSecurity.OAuth2ResourceServerSpec serverSpec = http.oauth2ResourceServer().bearerTokenConverter((ServerAuthenticationConverter)new ServerBearerTokenAuthenticationConverter());
        if (gatewayProperties.getUseJwtToken().booleanValue()) {
            serverSpec.jwt().authenticationManager(jwtReactiveAuthenticationManager);
        } else {
            ReactiveOpaqueTokenIntrospector introspector = (ReactiveOpaqueTokenIntrospector)reactiveOpaqueTokenIntrospector.getIfAvailable();
            Assert.notNull((Object)introspector, (String)"\u4e0d\u4f7f\u7528jwtToken\u65f6\uff0c\u672a\u521d\u59cb\u5316ReactiveOpaqueTokenIntrospector\u5904\u7406\u7c7b");
            serverSpec.opaqueToken().introspector(introspector);
        }
        ServerHttpSecurity.AuthorizeExchangeSpec authorizeExchangeSpec = http.authorizeExchange();
        if (ArrayUtils.isNotEmpty((Object[])gatewayProperties.getNoAuthUris())) {
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchangeSpec.pathMatchers(gatewayProperties.getNoAuthUris())).permitAll();
        }
        if (ArrayUtils.isNotEmpty((Object[])gatewayProperties.getLoginAuthUris())) {
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchangeSpec.pathMatchers(gatewayProperties.getLoginAuthUris())).authenticated();
        }
        ServerHttpSecurity security = ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)authorizeExchangeSpec.pathMatchers(HttpMethod.OPTIONS)).permitAll().anyExchange().access((ReactiveAuthorizationManager)authorizationManager).and().exceptionHandling().accessDeniedHandler(customServerAccessDeniedHandler).authenticationEntryPoint(customServerAuthenticationEntryPoint).and();
        if (gatewayProperties.getDisableCsrf().booleanValue()) {
            security.csrf().disable();
        }
        if (gatewayProperties.getDisableCors().booleanValue()) {
            security.cors().disable();
        }
        return http.build();
    }

    @Bean
    public ServerAccessDeniedHandler customServerAccessDeniedHandler(GatewayProperties gatewayProperties) {
        return (serverWebExchange, e) -> {
            Result result = new Result(gatewayProperties.getAccessDeniedCode(), e.getMessage());
            return this.write(result, serverWebExchange.getResponse(), (Exception)e);
        };
    }

    @Bean
    public ServerAuthenticationEntryPoint customServerAuthenticationEntryPoint(GatewayProperties gatewayProperties) {
        return (serverWebExchange, e) -> {
            MultiValueMap stateMap = serverWebExchange.getRequest().getQueryParams();
            String state = "";
            if (!CollectionUtils.isEmpty((Map)stateMap)) {
                state = (String)stateMap.getFirst((Object)"state");
            }
            if (StringUtils.isBlank((CharSequence)state)) {
                state = serverWebExchange.getRequest().getHeaders().getFirst("state");
            }
            String url = gatewayProperties.getLoginStateUris().get(state);
            Result result = new Result(gatewayProperties.getAuthFailCode(), e.getMessage());
            result.setData((Object)url);
            return this.write(result, serverWebExchange.getResponse(), (Exception)e);
        };
    }

    private Mono<Void> write(Result<?> body, ServerHttpResponse response, Exception e) {
        log.info("\u5f53\u524d\u7528\u6237\u8bbf\u95ee\u5f53\u524d\u5730\u5740\u5931\u8d25!\u9519\u8bef\u4fe1\u606f\u4e3a:[{}]", (Object)e.getMessage());
        String resultStr = JsonUtil.toJson(body);
        if (ObjectUtils.isEmpty((Object)resultStr)) {
            resultStr = "error";
        }
        response.setStatusCode(HttpStatus.OK);
        response.getHeaders().set("Content-Type", "application/json");
        response.getHeaders().set("Cache-Control", "no-cache");
        DataBuffer buffer = response.bufferFactory().wrap(resultStr.getBytes(StandardCharsets.UTF_8));
        return response.writeWith((Publisher)Mono.just((Object)buffer));
    }
}

