/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.authorization;

import cn.bbwres.biscuit.gateway.cache.ResourceCacheService;
import cn.bbwres.biscuit.gateway.utils.AuthUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import reactor.core.publisher.Mono;

public class AuthorizationManager
implements ReactiveAuthorizationManager<AuthorizationContext> {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationManager.class);
    private final ResourceCacheService resourceCacheService;
    private final PathMatcher pathMatcher;

    public Mono<AuthorizationDecision> check(Mono<Authentication> mono, AuthorizationContext authorizationContext) {
        ServerHttpRequest request = authorizationContext.getExchange().getRequest();
        String path = request.getURI().getPath();
        Mono authenticationMono = mono.filter(Authentication::isAuthenticated);
        Mono resourceMono = authenticationMono.map(authentication -> {
            HashSet<String> resources = new HashSet<String>();
            List<String> noAuthResource = this.resourceCacheService.getLoginAuthResource();
            if (!CollectionUtils.isEmpty(noAuthResource)) {
                resources.addAll(noAuthResource);
            }
            authorizationContext.getExchange().getAttributes().put("USER_INFO", authentication.getPrincipal());
            authentication.getAuthorities().stream().map(authority -> this.resourceCacheService.getResourceByRole(authority.getAuthority())).filter(Objects::nonNull).forEach(resources::addAll);
            return resources;
        });
        return resourceMono.map(resources -> AuthUtils.checkAuth(new ArrayList<String>((Collection<String>)resources), path, this.pathMatcher)).map(AuthorizationDecision::new).defaultIfEmpty((Object)new AuthorizationDecision(false));
    }

    public AuthorizationManager(ResourceCacheService resourceCacheService, PathMatcher pathMatcher) {
        this.resourceCacheService = resourceCacheService;
        this.pathMatcher = pathMatcher;
    }
}

