/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway.adapter;

import cn.bbwres.biscuit.exception.SystemRuntimeException;
import cn.bbwres.biscuit.exception.constants.GlobalErrorCodeConstants;
import cn.bbwres.biscuit.gateway.GatewayProperties;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.DefaultErrorAttributes;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ResponseStatusException;

public class ExtensionErrorAttributes
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(ExtensionErrorAttributes.class);
    private static final String RESULT_CODE = "resultCode";
    private static final String RESULT_MSG = "resultMsg";
    private final GatewayProperties gatewayProperties;
    private final MessageSourceAccessor messages;

    public Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        LinkedHashMap<String, Object> errorAttributes = new LinkedHashMap<String, Object>();
        Throwable error = this.getError(request);
        log.warn("\u5f53\u524d\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38!{}", (Object)error.getMessage());
        String message = error.getMessage();
        String errorCode = this.getErrorCode(error);
        MDC.clear();
        errorAttributes.put(RESULT_CODE, errorCode);
        if (!ObjectUtils.isEmpty((Object)this.messages)) {
            String language = request.headers().firstHeader("Accept-Language");
            Locale locale = LocaleContextHolder.getLocale();
            if (language != null) {
                locale = Locale.forLanguageTag(language);
            }
            message = this.messages.getMessage(errorCode, message, locale);
        }
        errorAttributes.put(RESULT_MSG, message);
        return errorAttributes;
    }

    private String getErrorCode(Throwable error) {
        Object errorCode = this.gatewayProperties.getSystemErrCode();
        if (error instanceof SystemRuntimeException) {
            SystemRuntimeException systemRuntimeException = (SystemRuntimeException)error;
            errorCode = systemRuntimeException.getErrorCode();
        }
        if (error instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)error;
            errorCode = GlobalErrorCodeConstants.GLOBAL_HTTP_CODE_PREFIX.getCode() + responseStatusException.getRawStatusCode();
        }
        return errorCode;
    }

    public ExtensionErrorAttributes(GatewayProperties gatewayProperties, MessageSourceAccessor messages) {
        this.gatewayProperties = gatewayProperties;
        this.messages = messages;
    }
}

