/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.gateway;

import cn.bbwres.biscuit.exception.constants.GlobalErrorCodeConstants;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="biscuit.gateway")
public class GatewayProperties {
    private String[] noAuthUris;
    private String[] loginAuthUris;
    private String accessDeniedCode = GlobalErrorCodeConstants.FORBIDDEN.getCode();
    private String authFailCode = GlobalErrorCodeConstants.UNAUTHORIZED.getCode();
    private String systemErrCode = GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode();
    private String userTokenHeader = "X-User-Token";
    private String userInfoHeader = "X-User-Info";
    private Boolean useXssFilter = false;
    private Boolean cacheResource = true;
    private Integer localCacheResourceTime = 300;
    private Boolean session;
    private Boolean useJwtToken = true;
    private Map<String, String> loginStateUris = new HashMap<String, String>(8);
    private Boolean disableCsrf = false;
    private Boolean disableCors = false;
    private Boolean dynamicRouteEnabled;
    private String dynamicRouteGroup = "DEFAULT_GROUP";
    private String dynamicRouteDataId;

    public String[] getNoAuthUris() {
        return this.noAuthUris;
    }

    public String[] getLoginAuthUris() {
        return this.loginAuthUris;
    }

    public String getAccessDeniedCode() {
        return this.accessDeniedCode;
    }

    public String getAuthFailCode() {
        return this.authFailCode;
    }

    public String getSystemErrCode() {
        return this.systemErrCode;
    }

    public String getUserTokenHeader() {
        return this.userTokenHeader;
    }

    public String getUserInfoHeader() {
        return this.userInfoHeader;
    }

    public Boolean getUseXssFilter() {
        return this.useXssFilter;
    }

    public Boolean getCacheResource() {
        return this.cacheResource;
    }

    public Integer getLocalCacheResourceTime() {
        return this.localCacheResourceTime;
    }

    public Boolean getSession() {
        return this.session;
    }

    public Boolean getUseJwtToken() {
        return this.useJwtToken;
    }

    public Map<String, String> getLoginStateUris() {
        return this.loginStateUris;
    }

    public Boolean getDisableCsrf() {
        return this.disableCsrf;
    }

    public Boolean getDisableCors() {
        return this.disableCors;
    }

    public Boolean getDynamicRouteEnabled() {
        return this.dynamicRouteEnabled;
    }

    public String getDynamicRouteGroup() {
        return this.dynamicRouteGroup;
    }

    public String getDynamicRouteDataId() {
        return this.dynamicRouteDataId;
    }

    public void setNoAuthUris(String[] noAuthUris) {
        this.noAuthUris = noAuthUris;
    }

    public void setLoginAuthUris(String[] loginAuthUris) {
        this.loginAuthUris = loginAuthUris;
    }

    public void setAccessDeniedCode(String accessDeniedCode) {
        this.accessDeniedCode = accessDeniedCode;
    }

    public void setAuthFailCode(String authFailCode) {
        this.authFailCode = authFailCode;
    }

    public void setSystemErrCode(String systemErrCode) {
        this.systemErrCode = systemErrCode;
    }

    public void setUserTokenHeader(String userTokenHeader) {
        this.userTokenHeader = userTokenHeader;
    }

    public void setUserInfoHeader(String userInfoHeader) {
        this.userInfoHeader = userInfoHeader;
    }

    public void setUseXssFilter(Boolean useXssFilter) {
        this.useXssFilter = useXssFilter;
    }

    public void setCacheResource(Boolean cacheResource) {
        this.cacheResource = cacheResource;
    }

    public void setLocalCacheResourceTime(Integer localCacheResourceTime) {
        this.localCacheResourceTime = localCacheResourceTime;
    }

    public void setSession(Boolean session) {
        this.session = session;
    }

    public void setUseJwtToken(Boolean useJwtToken) {
        this.useJwtToken = useJwtToken;
    }

    public void setLoginStateUris(Map<String, String> loginStateUris) {
        this.loginStateUris = loginStateUris;
    }

    public void setDisableCsrf(Boolean disableCsrf) {
        this.disableCsrf = disableCsrf;
    }

    public void setDisableCors(Boolean disableCors) {
        this.disableCors = disableCors;
    }

    public void setDynamicRouteEnabled(Boolean dynamicRouteEnabled) {
        this.dynamicRouteEnabled = dynamicRouteEnabled;
    }

    public void setDynamicRouteGroup(String dynamicRouteGroup) {
        this.dynamicRouteGroup = dynamicRouteGroup;
    }

    public void setDynamicRouteDataId(String dynamicRouteDataId) {
        this.dynamicRouteDataId = dynamicRouteDataId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GatewayProperties)) {
            return false;
        }
        GatewayProperties other = (GatewayProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$useXssFilter = this.getUseXssFilter();
        Boolean other$useXssFilter = other.getUseXssFilter();
        if (this$useXssFilter == null ? other$useXssFilter != null : !((Object)this$useXssFilter).equals(other$useXssFilter)) {
            return false;
        }
        Boolean this$cacheResource = this.getCacheResource();
        Boolean other$cacheResource = other.getCacheResource();
        if (this$cacheResource == null ? other$cacheResource != null : !((Object)this$cacheResource).equals(other$cacheResource)) {
            return false;
        }
        Integer this$localCacheResourceTime = this.getLocalCacheResourceTime();
        Integer other$localCacheResourceTime = other.getLocalCacheResourceTime();
        if (this$localCacheResourceTime == null ? other$localCacheResourceTime != null : !((Object)this$localCacheResourceTime).equals(other$localCacheResourceTime)) {
            return false;
        }
        Boolean this$session = this.getSession();
        Boolean other$session = other.getSession();
        if (this$session == null ? other$session != null : !((Object)this$session).equals(other$session)) {
            return false;
        }
        Boolean this$useJwtToken = this.getUseJwtToken();
        Boolean other$useJwtToken = other.getUseJwtToken();
        if (this$useJwtToken == null ? other$useJwtToken != null : !((Object)this$useJwtToken).equals(other$useJwtToken)) {
            return false;
        }
        Boolean this$disableCsrf = this.getDisableCsrf();
        Boolean other$disableCsrf = other.getDisableCsrf();
        if (this$disableCsrf == null ? other$disableCsrf != null : !((Object)this$disableCsrf).equals(other$disableCsrf)) {
            return false;
        }
        Boolean this$disableCors = this.getDisableCors();
        Boolean other$disableCors = other.getDisableCors();
        if (this$disableCors == null ? other$disableCors != null : !((Object)this$disableCors).equals(other$disableCors)) {
            return false;
        }
        Boolean this$dynamicRouteEnabled = this.getDynamicRouteEnabled();
        Boolean other$dynamicRouteEnabled = other.getDynamicRouteEnabled();
        if (this$dynamicRouteEnabled == null ? other$dynamicRouteEnabled != null : !((Object)this$dynamicRouteEnabled).equals(other$dynamicRouteEnabled)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNoAuthUris(), other.getNoAuthUris())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLoginAuthUris(), other.getLoginAuthUris())) {
            return false;
        }
        String this$accessDeniedCode = this.getAccessDeniedCode();
        String other$accessDeniedCode = other.getAccessDeniedCode();
        if (this$accessDeniedCode == null ? other$accessDeniedCode != null : !this$accessDeniedCode.equals(other$accessDeniedCode)) {
            return false;
        }
        String this$authFailCode = this.getAuthFailCode();
        String other$authFailCode = other.getAuthFailCode();
        if (this$authFailCode == null ? other$authFailCode != null : !this$authFailCode.equals(other$authFailCode)) {
            return false;
        }
        String this$systemErrCode = this.getSystemErrCode();
        String other$systemErrCode = other.getSystemErrCode();
        if (this$systemErrCode == null ? other$systemErrCode != null : !this$systemErrCode.equals(other$systemErrCode)) {
            return false;
        }
        String this$userTokenHeader = this.getUserTokenHeader();
        String other$userTokenHeader = other.getUserTokenHeader();
        if (this$userTokenHeader == null ? other$userTokenHeader != null : !this$userTokenHeader.equals(other$userTokenHeader)) {
            return false;
        }
        String this$userInfoHeader = this.getUserInfoHeader();
        String other$userInfoHeader = other.getUserInfoHeader();
        if (this$userInfoHeader == null ? other$userInfoHeader != null : !this$userInfoHeader.equals(other$userInfoHeader)) {
            return false;
        }
        Map<String, String> this$loginStateUris = this.getLoginStateUris();
        Map<String, String> other$loginStateUris = other.getLoginStateUris();
        if (this$loginStateUris == null ? other$loginStateUris != null : !((Object)this$loginStateUris).equals(other$loginStateUris)) {
            return false;
        }
        String this$dynamicRouteGroup = this.getDynamicRouteGroup();
        String other$dynamicRouteGroup = other.getDynamicRouteGroup();
        if (this$dynamicRouteGroup == null ? other$dynamicRouteGroup != null : !this$dynamicRouteGroup.equals(other$dynamicRouteGroup)) {
            return false;
        }
        String this$dynamicRouteDataId = this.getDynamicRouteDataId();
        String other$dynamicRouteDataId = other.getDynamicRouteDataId();
        return !(this$dynamicRouteDataId == null ? other$dynamicRouteDataId != null : !this$dynamicRouteDataId.equals(other$dynamicRouteDataId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GatewayProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useXssFilter = this.getUseXssFilter();
        result = result * 59 + ($useXssFilter == null ? 43 : ((Object)$useXssFilter).hashCode());
        Boolean $cacheResource = this.getCacheResource();
        result = result * 59 + ($cacheResource == null ? 43 : ((Object)$cacheResource).hashCode());
        Integer $localCacheResourceTime = this.getLocalCacheResourceTime();
        result = result * 59 + ($localCacheResourceTime == null ? 43 : ((Object)$localCacheResourceTime).hashCode());
        Boolean $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : ((Object)$session).hashCode());
        Boolean $useJwtToken = this.getUseJwtToken();
        result = result * 59 + ($useJwtToken == null ? 43 : ((Object)$useJwtToken).hashCode());
        Boolean $disableCsrf = this.getDisableCsrf();
        result = result * 59 + ($disableCsrf == null ? 43 : ((Object)$disableCsrf).hashCode());
        Boolean $disableCors = this.getDisableCors();
        result = result * 59 + ($disableCors == null ? 43 : ((Object)$disableCors).hashCode());
        Boolean $dynamicRouteEnabled = this.getDynamicRouteEnabled();
        result = result * 59 + ($dynamicRouteEnabled == null ? 43 : ((Object)$dynamicRouteEnabled).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNoAuthUris());
        result = result * 59 + Arrays.deepHashCode(this.getLoginAuthUris());
        String $accessDeniedCode = this.getAccessDeniedCode();
        result = result * 59 + ($accessDeniedCode == null ? 43 : $accessDeniedCode.hashCode());
        String $authFailCode = this.getAuthFailCode();
        result = result * 59 + ($authFailCode == null ? 43 : $authFailCode.hashCode());
        String $systemErrCode = this.getSystemErrCode();
        result = result * 59 + ($systemErrCode == null ? 43 : $systemErrCode.hashCode());
        String $userTokenHeader = this.getUserTokenHeader();
        result = result * 59 + ($userTokenHeader == null ? 43 : $userTokenHeader.hashCode());
        String $userInfoHeader = this.getUserInfoHeader();
        result = result * 59 + ($userInfoHeader == null ? 43 : $userInfoHeader.hashCode());
        Map<String, String> $loginStateUris = this.getLoginStateUris();
        result = result * 59 + ($loginStateUris == null ? 43 : ((Object)$loginStateUris).hashCode());
        String $dynamicRouteGroup = this.getDynamicRouteGroup();
        result = result * 59 + ($dynamicRouteGroup == null ? 43 : $dynamicRouteGroup.hashCode());
        String $dynamicRouteDataId = this.getDynamicRouteDataId();
        result = result * 59 + ($dynamicRouteDataId == null ? 43 : $dynamicRouteDataId.hashCode());
        return result;
    }

    public String toString() {
        return "GatewayProperties(noAuthUris=" + Arrays.deepToString(this.getNoAuthUris()) + ", loginAuthUris=" + Arrays.deepToString(this.getLoginAuthUris()) + ", accessDeniedCode=" + this.getAccessDeniedCode() + ", authFailCode=" + this.getAuthFailCode() + ", systemErrCode=" + this.getSystemErrCode() + ", userTokenHeader=" + this.getUserTokenHeader() + ", userInfoHeader=" + this.getUserInfoHeader() + ", useXssFilter=" + this.getUseXssFilter() + ", cacheResource=" + this.getCacheResource() + ", localCacheResourceTime=" + this.getLocalCacheResourceTime() + ", session=" + this.getSession() + ", useJwtToken=" + this.getUseJwtToken() + ", loginStateUris=" + this.getLoginStateUris() + ", disableCsrf=" + this.getDisableCsrf() + ", disableCors=" + this.getDisableCors() + ", dynamicRouteEnabled=" + this.getDynamicRouteEnabled() + ", dynamicRouteGroup=" + this.getDynamicRouteGroup() + ", dynamicRouteDataId=" + this.getDynamicRouteDataId() + ")";
    }
}

