/*
 *
 *  * Copyright 2024 bbwres
 *  *
 *  * Licensed under the Apache License, Version 2.0 (the "License");
 *  * you may not use this file except in compliance with the License.
 *  * You may obtain a copy of the License at
 *  *
 *  *      http://www.apache.org/licenses/LICENSE-2.0
 *  *
 *  * Unless required by applicable law or agreed to in writing, software
 *  * distributed under the License is distributed on an "AS IS" BASIS,
 *  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  * See the License for the specific language governing permissions and
 *  * limitations under the License.
 *
 */

package cn.bbwres.biscuit.gateway.exception;

import lombok.Getter;
import org.springframework.http.HttpStatus;

/**
 * 外部接口请求异常
 *
 * @author zhanglinfeng
 * @version $Id: $Id
 */
@Getter
public class AccessRequestException extends RuntimeException {
    private static final long serialVersionUID = -3167373523458709045L;

    /**
     * http 状态码
     */
    private final HttpStatus status;

    /**
     * <p>Constructor for AccessRequestException.</p>
     *
     * @param status a {@link org.springframework.http.HttpStatus} object
     * @param message a {@link java.lang.String} object
     */
    public AccessRequestException(HttpStatus status, String message) {
        super(message);
        this.status = status;
    }

}
