/*
 * Decompiled with CFR 0.152.
 */
package cn.bbwres.biscuit.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.springframework.util.ObjectUtils;

public class JsonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtil.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final ObjectMapper OBJECT_MAPPER;

    public static <T> String toJson(T t) {
        try {
            return OBJECT_MAPPER.writeValueAsString(t);
        }
        catch (JsonProcessingException e) {
            LOG.info("toJson error!,{}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> String toJsonBase64(T t) {
        String json = JsonUtil.toJson(t);
        if (ObjectUtils.isEmpty((Object)json)) {
            return null;
        }
        return Base64Utils.encodeToUrlSafeString((byte[])json.getBytes());
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            LOG.info("json  to Object error, {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T toObjectByBase64Json(String base64Json, Class<T> clazz) {
        String json = new String(Base64Utils.decodeFromUrlSafeString((String)base64Json), StandardCharsets.UTF_8);
        return JsonUtil.toObject(json, clazz);
    }

    public static <T> T toObject(String json, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, valueTypeRef);
        }
        catch (JsonProcessingException e) {
            LOG.info("json  to Object error, {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Map<String, ?> object2Map(Object obj) {
        Map params = null;
        try {
            params = (Map)OBJECT_MAPPER.readValue(OBJECT_MAPPER.writeValueAsString(obj), new TypeReference<Map<String, ?>>(){});
        }
        catch (Exception e) {
            LOG.warn("object  to Map error, {}", (Object)e.getMessage());
        }
        return params;
    }

    public static Map<String, Object> jsonString2MapObj(String jsonStr) {
        Map params = null;
        try {
            params = (Map)OBJECT_MAPPER.readValue(jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            LOG.warn("json  to Map error, {}", (Object)e.getMessage());
        }
        return params;
    }

    static {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern(DATE_TIME_FORMAT)));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern(TIME_FORMAT)));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern(DATE_TIME_FORMAT)));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern(TIME_FORMAT)));
        OBJECT_MAPPER = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat(DATE_TIME_FORMAT)).registerModule((Module)new JavaTimeModule());
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

