/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.internal;

import cn.authing.internal.AppInfo;
import cn.authing.internal.AuthingImpl;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsUtil {
    private static final String URL_SDK = "https://developer-beta.authing.cn/stats/sdk-trace";
    private static final String SDK_VERSION = "1.0.0";
    private static final int AUDIT_TIMEOUT = 3000;
    private static final Logger logger = LoggerFactory.getLogger(StatsUtil.class);

    public static void trace() {
        if (AuthingImpl.sUseDynamicAppInfo) {
            for (AppInfo appInfo : AuthingImpl.sDomainAppInfoRegistry.values()) {
                StatsUtil.doTrace(appInfo.getId(), appInfo.getSecret());
            }
        } else {
            StatsUtil.doTrace(AuthingImpl.sAppId, AuthingImpl.sAppSecret);
        }
    }

    private static void doTrace(String appId, String appSecret) {
        try {
            URL obj = new URL("https://developer-beta.authing.cn/stats/sdk-trace?appid=" + appId + "&appSecret=" + appSecret + "&sdk=java-spring-boot&version=" + SDK_VERSION);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setConnectTimeout(3000);
            int responseCode = con.getResponseCode();
            if (responseCode != 200) {
                logger.info("sdk trace failed:" + responseCode);
            }
        }
        catch (Exception e) {
            logger.error("sdk trace failed:", (Throwable)e);
        }
    }
}

