/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.internal;

import cn.authing.AuthParams;
import cn.authing.CooperatorInfo;
import cn.authing.UserInfo;
import cn.authing.UserPool;
import cn.authing.UserPoolDetail;
import cn.authing.common.AuthingResult;
import cn.authing.internal.AppInfo;
import cn.authing.internal.AuthInfo;
import cn.authing.internal.GetUserByTokenResponse;
import cn.authing.internal.Jwk;
import cn.authing.internal.StatsUtil;
import cn.authing.internal.Util;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthingImpl {
    private static final Logger logger = LoggerFactory.getLogger(AuthingImpl.class);
    private static final String PATH_SIGN_IN = "/oidc/auth?client_id=";
    private static final String PATH_GET_AK = "/oidc/token";
    private static final String PATH_ME = "/oidc/me?access_token=";
    private static final String PATH_USERS_ME = "/api/v2/users/me";
    private static final String PATH_JWKS = "/oidc/.well-known/jwks.json";
    private static final String PATH_GET_APP_INFO = "/api/v2/applications/getAppInfo/default";
    private static final String PATH_GET_USER_POOL_LIST = "/api/v2/userpools/getUserPoolList";
    private static final String PATH_COOPERATORS = "/api/v2/cooperators";
    private static final String PATH_GRAPH_CALL = "/graphql/v2";
    private static final String APP_SESSION_ID = "authing_app_session_id";
    private static final String APP_ID_TOKEN = "authing_id_token";
    private static final String DOMAIN_SUFFIX = ".";
    private static final int CONNECTION_TIMEOUT = 10000;
    private static long sCacheValidDuration = 36000000L;
    static String sUserPoolId;
    static String sAppId;
    static String sAppSecret;
    static String sHost;
    static String sCallbackUrl;
    static Jwk sJWK;
    static boolean sVerifyRemotely;
    static boolean sSetCookieOnTopDomain;
    static boolean sIncludeIDTokenInCookie;
    static boolean sUseDynamicAppInfo;
    static String sRootUserPoolId;
    static String sRootUserPoolSecret;
    static final Map<String, AppInfo> sDomainAppInfoRegistry;
    private static final Map<String, AuthInfo> sCache;
    private static final CleanCacheTask cleanCacheTask;
    private static final Timer timer;

    public static void setUserPoolId(String userPoolId) {
        sUserPoolId = userPoolId;
    }

    public static void setAppInfo(String appId, String appSecret) {
        sAppId = appId;
        sAppSecret = appSecret;
    }

    public static void setHost(String host) {
        sHost = host;
        if (sHost != null) {
            sJWK = Jwk.create(sHost + PATH_JWKS);
        }
    }

    public static void setCallback(String callback) {
        sCallbackUrl = callback;
    }

    public static void setVerifyRemotely(boolean verifyRemotely) {
        sVerifyRemotely = verifyRemotely;
    }

    public static void setCookieOnTopDomain(boolean onTopDomain) {
        sSetCookieOnTopDomain = onTopDomain;
    }

    public static void setIncludeIDTokenInCookie(boolean idTokenInCookie) {
        sIncludeIDTokenInCookie = idTokenInCookie;
    }

    public static void setUseDynamicAppInfo(boolean useDynamicAppInfo) {
        sUseDynamicAppInfo = useDynamicAppInfo;
    }

    public static void setRootUserPoolId(String rootUserPoolId) {
        sRootUserPoolId = rootUserPoolId;
    }

    public static void setRootUserPoolSecret(String rootUserPoolSecret) {
        sRootUserPoolSecret = rootUserPoolSecret;
    }

    public static UserInfo getUserInfo(HttpServletRequest request, HttpServletResponse response, AuthParams authParams) {
        if (AuthingImpl.getAppId(request) == null || AuthingImpl.getAppSecret(request) == null) {
            logger.error("app info not set. Please call Authing.setAppInfo(appId, appSecret) during app startup when useDynamicAppInfo is false. Please call Authing.setRootUserPoolId(String rootUserPoolId) and Authing.setRootUserPoolSecret(String rootUserPoolSecret) during app startup when useDynamicAppInfo is true");
            return null;
        }
        if (sHost == null) {
            logger.error("app host not set. Please call Authing.setHost(host) during app startup. Note this host is your app specific, e.g. https://myapp.authing.cn");
            return null;
        }
        if (AuthingImpl.getCallbackUrl(request) == null) {
            logger.error("callback url not set. Please call Authing.setCallback(callbackUrl) during app startup. as per OAuth 2.0 specification, callback has to be negotiated during registration");
            return null;
        }
        try {
            UserInfo userInfo = AuthingImpl.verify(request);
            if (userInfo != null) {
                return userInfo;
            }
            String authorization = request.getHeader("Authorization");
            if (authorization == null) {
                authorization = request.getHeader("authorization");
            }
            if (authorization != null) {
                userInfo = AuthingImpl.getUserInfoByToken(authorization);
            }
            if (userInfo == null) {
                AuthingImpl.gotoSignIn(request, response, authParams);
            }
            return userInfo;
        }
        catch (Exception e) {
            logger.error("getUserInfo exception", (Throwable)e);
            return null;
        }
    }

    private static void gotoSignIn(HttpServletRequest request, HttpServletResponse response, AuthParams authParams) throws Exception {
        if (authParams == null || !authParams.isGotoLogin()) {
            return;
        }
        String cur = Util.getRequestURLWithParas(request);
        request.getSession(true).setAttribute("last_visited_url", (Object)cur);
        String callbackUrl = authParams.getCallbackUrl();
        if (callbackUrl == null) {
            callbackUrl = AuthingImpl.getCallbackUrl(request);
        }
        String url = sHost + PATH_SIGN_IN + AuthingImpl.getAppId(request) + "&scope=" + authParams.getScope() + "&state=" + Util.randomString(12) + "&nonce=" + Util.randomString(12) + "&response_type=" + authParams.getResponseType() + "&redirect_uri=" + URLEncoder.encode(callbackUrl, "utf-8");
        response.sendRedirect(url);
    }

    public static UserInfo onLogin(HttpServletRequest request, HttpServletResponse response, AuthParams authParams) {
        String code = request.getParameter("code");
        if (code == null || code.length() == 0) {
            logger.error("Auth failed. Code is empty");
            return null;
        }
        try {
            URL obj = new URL(sHost + PATH_GET_AK);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setConnectTimeout(10000);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            String callbackUrl = authParams.getCallbackUrl();
            if (callbackUrl == null) {
                callbackUrl = AuthingImpl.getCallbackUrl(request);
            }
            String body = "client_id=" + AuthingImpl.getAppId(request) + "&client_secret=" + AuthingImpl.getAppSecret(request) + "&grant_type=" + authParams.getGrantType() + "&code=" + code + "&redirect_uri=" + callbackUrl;
            os.write(body.getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                UserInfo userInfo;
                String res = Util.getStringFromStream(con.getInputStream());
                AuthInfo authInfo = (AuthInfo)JSON.parseObject((String)res, AuthInfo.class);
                if (authInfo == null || authInfo.getId_token() == null || authInfo.getAccess_token() == null) {
                    logger.error("Auth failed. AK or ID Token is empty");
                    return null;
                }
                String appSessionID = AuthingImpl.getAppSessionID(request);
                if (sVerifyRemotely) {
                    userInfo = AuthingImpl.verifyTokenRemotely(authInfo.getAccess_token());
                    if (userInfo != null) {
                        authInfo.setLastValidTime(System.currentTimeMillis());
                        sCache.put(appSessionID, authInfo);
                    }
                } else {
                    userInfo = AuthingImpl.verify(appSessionID, authInfo.getId_token(), AuthingImpl.getAppSecret(request));
                }
                Util.createCookie(request, response, APP_SESSION_ID, appSessionID, sSetCookieOnTopDomain);
                if (sIncludeIDTokenInCookie) {
                    Util.createCookie(request, response, APP_ID_TOKEN, authInfo.getId_token(), sSetCookieOnTopDomain);
                }
                if (userInfo == null) {
                    logger.error("Auth failed. verify token failed");
                } else {
                    userInfo.setAccessToken(authInfo.getAccess_token());
                }
                return userInfo;
            }
            String res = Util.getStringFromStream(con.getErrorStream());
            logger.error("get access token failed. Status code:" + responseCode + " Error:" + res);
            return null;
        }
        catch (Exception e) {
            logger.error("get access token failed:", (Throwable)e);
            return null;
        }
    }

    private static String getAppId(HttpServletRequest request) {
        if (sUseDynamicAppInfo) {
            AppInfo appInfo = AuthingImpl.getDynamicAppInfoByRequestDomain(request);
            if (appInfo == null) {
                return null;
            }
            return appInfo.getId();
        }
        return sAppId;
    }

    private static String getAppSecret(HttpServletRequest request) {
        if (sUseDynamicAppInfo) {
            AppInfo appInfo = AuthingImpl.getDynamicAppInfoByRequestDomain(request);
            if (appInfo == null) {
                return null;
            }
            return appInfo.getSecret();
        }
        return sAppSecret;
    }

    private static String getCallbackUrl(HttpServletRequest request) {
        if (sUseDynamicAppInfo) {
            AppInfo appInfo = AuthingImpl.getDynamicAppInfoByRequestDomain(request);
            if (appInfo == null) {
                return null;
            }
            if (appInfo.getRedirectUris() == null || appInfo.getRedirectUris().size() == 0) {
                return null;
            }
            return appInfo.getRedirectUris().get(0);
        }
        return sCallbackUrl;
    }

    private static String getAuthorization(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            authorization = request.getHeader("authorization");
        }
        return authorization;
    }

    private static AppInfo getDynamicAppInfoByRequestDomain(HttpServletRequest request) {
        if (sRootUserPoolId == null || sRootUserPoolSecret == null) {
            logger.error("Get dynamic app info fail, rootUserPoolId is null or rootUserPoolSecret is null");
            return null;
        }
        StringBuffer url = request.getRequestURL();
        String host = url.substring(request.getScheme().length() + 3, url.length() - request.getRequestURI().length());
        if (!host.contains(DOMAIN_SUFFIX)) {
            logger.error("Get dynamic app info fail, invalid host named [{}]", (Object)host);
            return null;
        }
        String domain = host.substring(0, host.indexOf(DOMAIN_SUFFIX)).toLowerCase();
        AppInfo appInfo = sDomainAppInfoRegistry.get(domain);
        if (appInfo != null) {
            return appInfo;
        }
        try {
            URL obj = new URL(sHost + PATH_GET_APP_INFO);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            con.setRequestProperty("Authorization", AuthingImpl.getAuthorization(request));
            con.setConnectTimeout(10000);
            con.setDoOutput(true);
            DataOutputStream os = new DataOutputStream(con.getOutputStream());
            Properties params = new Properties();
            params.put("rootUserPoolId", sRootUserPoolId);
            params.put("rootUserPoolSecret", sRootUserPoolSecret);
            params.put("domain", domain);
            os.write(JSON.toJSONString((Object)params).getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode == 200 || 201 == responseCode) {
                String resStr = Util.getStringFromStream(con.getInputStream());
                AuthingResult res = (AuthingResult)JSON.parseObject((String)resStr, (TypeReference)new TypeReference<AuthingResult<AppInfo>>(){}, (Feature[])new Feature[0]);
                if (200 == res.getCode()) {
                    appInfo = (AppInfo)res.getData();
                    if (appInfo == null || appInfo.getId() == null || appInfo.getSecret() == null) {
                        logger.error("Get app info failed. App id or app secret is empty");
                        return null;
                    }
                    sDomainAppInfoRegistry.put(domain, appInfo);
                    return appInfo;
                }
                logger.error("Get app info failed. Authing result code:" + res.getCode() + ", Authing result message:" + res.getMessage());
            } else {
                String res = Util.getStringFromStream(con.getErrorStream());
                logger.error("Get app info failed. Status code:" + responseCode + ", Error:" + res);
            }
        }
        catch (Exception e) {
            logger.error("Get app info failed. ", (Throwable)e);
        }
        return null;
    }

    private static UserInfo verify(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        String appSessionID = AuthingImpl.getAppSessionIDFromCookie(cookies);
        if (sIncludeIDTokenInCookie) {
            String idToken = AuthingImpl.getIDTokenFromCookie(cookies);
            if (sVerifyRemotely) {
                return AuthingImpl.verifyTokenRemotely(idToken);
            }
            return AuthingImpl.verify(appSessionID, idToken, AuthingImpl.getAppSecret(request));
        }
        if (sVerifyRemotely) {
            if (appSessionID != null) {
                AuthInfo authInfo = sCache.get(appSessionID);
                if (authInfo != null) {
                    return AuthingImpl.verifyTokenRemotely(authInfo.getAccess_token());
                }
                return null;
            }
            return null;
        }
        return AuthingImpl.verify(appSessionID, null, AuthingImpl.getAppSecret(request));
    }

    private static UserInfo verify(String key, String idToken, String appSecret) {
        UserInfo userInfo;
        if (key == null || key.length() == 0) {
            return null;
        }
        AuthInfo cache = sCache.get(key);
        if (cache != null) {
            long now = System.currentTimeMillis();
            if (now - cache.getLastValidTime() < sCacheValidDuration) {
                cache.setLastValidTime(now);
                return cache.getUserInfo();
            }
            sCache.remove(key);
            return null;
        }
        if (idToken != null && idToken.length() > 0 && (userInfo = AuthingImpl.verifyIdToken(idToken, appSecret)) != null) {
            AuthInfo authInfo = new AuthInfo();
            authInfo.setUserInfo(userInfo);
            authInfo.setLastValidTime(System.currentTimeMillis());
            sCache.put(key, authInfo);
            return userInfo;
        }
        return null;
    }

    private static UserInfo verifyTokenRemotely(String accessToken) {
        if (accessToken == null || accessToken.length() == 0) {
            return null;
        }
        try {
            URL obj = new URL(sHost + PATH_ME + accessToken);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setConnectTimeout(10000);
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String res = Util.getStringFromStream(con.getInputStream());
                UserInfo userInfo = (UserInfo)JSON.parseObject((String)res, UserInfo.class);
                if (userInfo == null) {
                    logger.error("Get user info failed");
                    return null;
                }
                return userInfo;
            }
            String res = Util.getStringFromStream(con.getErrorStream());
            logger.error("verify access token failed. Status code:" + responseCode + " Error:" + res);
            return null;
        }
        catch (Exception e) {
            logger.error("verify access token failed:", (Throwable)e);
            return null;
        }
    }

    private static UserInfo getUserInfoByToken(String token) {
        if (token == null || token.length() == 0 || sUserPoolId == null) {
            return null;
        }
        try {
            URL obj = new URL(sHost + PATH_USERS_ME);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestProperty("x-authing-userpool-id", sUserPoolId);
            con.setRequestProperty("Authorization", token);
            con.setConnectTimeout(10000);
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String res = Util.getStringFromStream(con.getInputStream());
                GetUserByTokenResponse response = (GetUserByTokenResponse)JSON.parseObject((String)res, GetUserByTokenResponse.class);
                if (response == null) {
                    logger.error("Get user info failed");
                    return null;
                }
                return response.getData();
            }
            String res = Util.getStringFromStream(con.getErrorStream());
            logger.error("verify access token failed. Status code:" + responseCode + " Error:" + res);
            return null;
        }
        catch (Exception e) {
            logger.error("verify access token failed:", (Throwable)e);
            return null;
        }
    }

    private static UserInfo verifyIdToken(String idToken, String appSecret) {
        try {
            DecodedJWT jwt = AuthingImpl.verifyToken(idToken, appSecret);
            if (jwt == null) {
                return null;
            }
            if (jwt.getExpiresAt().before(Calendar.getInstance().getTime())) {
                throw new RuntimeException("Expired token!");
            }
            sCacheValidDuration = jwt.getExpiresAt().getTime() - Calendar.getInstance().getTimeInMillis();
            return Util.getUserInfo(jwt);
        }
        catch (SignatureVerificationException e) {
            logger.error("jwt verification failed", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("jwt verification exception", (Throwable)e);
        }
        return null;
    }

    private static DecodedJWT verifyToken(String idToken, String appSecret) {
        DecodedJWT jwt = Jwk.verifyToken(idToken, sJWK, appSecret);
        if (jwt == null) {
            sJWK = Jwk.create(sHost + PATH_JWKS);
            jwt = Jwk.verifyToken(idToken, sJWK, appSecret);
        }
        return jwt;
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response, String redirect_uri) {
        try {
            Cookie[] cookies = request.getCookies();
            String appSessionID = AuthingImpl.getAppSessionIDFromCookie(cookies);
            if (appSessionID != null && appSessionID.length() > 0) {
                sCache.remove(appSessionID);
            }
            Util.deleteCookie(request, response, APP_SESSION_ID, sSetCookieOnTopDomain);
            Util.deleteCookie(request, response, APP_ID_TOKEN, sSetCookieOnTopDomain);
            String url = sHost + "/login/profile/logout";
            if (redirect_uri != null) {
                url = url + "?redirect_uri=" + redirect_uri;
            }
            response.sendRedirect(url);
        }
        catch (Exception e) {
            logger.error("logout failed", (Throwable)e);
        }
    }

    private static String getAppSessionID(HttpServletRequest request) {
        String sessionID = AuthingImpl.getAppSessionIDFromCookie(request.getCookies());
        if (sessionID != null && sessionID.length() > 0) {
            return sessionID;
        }
        return Util.randomString(16);
    }

    private static String getAppSessionIDFromCookie(Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!APP_SESSION_ID.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    private static String getIDTokenFromCookie(Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!APP_ID_TOKEN.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static List<UserPool> getUserPoolListByRoot(HttpServletRequest request, String rootUserPoolId, String rootUserPoolSecret) {
        try {
            URL obj = new URL(sHost + PATH_GET_USER_POOL_LIST);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            con.setRequestProperty("Authorization", AuthingImpl.getAuthorization(request));
            con.setConnectTimeout(10000);
            con.setDoOutput(true);
            DataOutputStream os = new DataOutputStream(con.getOutputStream());
            Properties params = new Properties();
            params.put("rootUserPoolId", rootUserPoolId);
            params.put("rootUserPoolSecret", rootUserPoolSecret);
            os.write(JSON.toJSONString((Object)params).getBytes());
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode == 200 || 201 == responseCode) {
                String resStr = Util.getStringFromStream(con.getInputStream());
                AuthingResult res = (AuthingResult)JSON.parseObject((String)resStr, (TypeReference)new TypeReference<AuthingResult<List<UserPool>>>(){}, (Feature[])new Feature[0]);
                if (200 == res.getCode()) {
                    return (List)res.getData();
                }
                logger.error("Get user pool list by root info failed. Authing result code:" + res.getCode() + ", Authing result message:" + res.getMessage());
            } else {
                String res = Util.getStringFromStream(con.getErrorStream());
                logger.error("Get app info failed. Status code:" + responseCode + ", Error:" + res);
            }
        }
        catch (Exception e) {
            logger.error("Get app info failed. ", (Throwable)e);
        }
        return null;
    }

    public static Boolean isUserPoolAdministrator(HttpServletRequest request, String userId) {
        HttpsURLConnection con;
        URL obj;
        HashSet<String> cooperatorIds;
        block12: {
            if (sRootUserPoolId == null || sRootUserPoolSecret == null || userId == null) {
                logger.error("invalid param (rootUserPoolId | rootUserPoolSecret | userId)");
                return null;
            }
            cooperatorIds = new HashSet<String>();
            try {
                obj = new URL(sHost + PATH_COOPERATORS);
                con = (HttpsURLConnection)obj.openConnection();
                con.setRequestProperty("x-authing-userpool-id", sRootUserPoolId);
                con.setRequestProperty("Authorization", AuthingImpl.getAuthorization(request));
                con.setConnectTimeout(10000);
                int responseCode = con.getResponseCode();
                if (responseCode == 200) {
                    String res = Util.getStringFromStream(con.getInputStream());
                    AuthingResult response = (AuthingResult)JSON.parseObject((String)res, (TypeReference)new TypeReference<AuthingResult<List<CooperatorInfo>>>(){}, (Feature[])new Feature[0]);
                    if (response == null) {
                        logger.error("Get cooperators info failed");
                        return null;
                    }
                    if (response.getData() != null) {
                        for (CooperatorInfo cooperator : (List)response.getData()) {
                            cooperatorIds.add(cooperator.getUser().getId());
                        }
                    }
                    break block12;
                }
                String res = Util.getStringFromStream(con.getErrorStream());
                logger.error("Get cooperators info failed. Status code:" + responseCode + " Error:" + res);
                return null;
            }
            catch (Exception e) {
                logger.error("Get cooperators info failed:", (Throwable)e);
            }
        }
        try {
            AuthingResult response;
            String res;
            obj = new URL(sHost + PATH_GRAPH_CALL);
            con = (HttpsURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("x-authing-userpool-id", sUserPoolId);
            con.setRequestProperty("Authorization", AuthingImpl.getAuthorization(request));
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("x-authing-request-from", "SDK");
            con.setRequestProperty("x-authing-sdk-version", "1.0.4");
            con.setRequestProperty("x-authing-app-id", "" + AuthingImpl.getAppId(request));
            con.setConnectTimeout(10000);
            con.setDoInput(true);
            con.setDoOutput(true);
            DataOutputStream os = new DataOutputStream(con.getOutputStream());
            byte[] bytes = JSON.parseObject((String)"{\n    \"query\":\"\nquery userpool {\n  userpool {\n    id\n    name\n    domain\n    description\n    secret\n    jwtSecret\n    ownerId\n    userpoolTypes {\n      code\n      name\n      description\n      image\n      sdks\n    }\n    logo\n    createdAt\n    updatedAt\n    emailVerifiedDefault\n    sendWelcomeEmail\n    registerDisabled\n    appSsoEnabled\n    showWxQRCodeWhenRegisterDisabled\n    allowedOrigins\n    tokenExpiresAfter\n    isDeleted\n    frequentRegisterCheck {\n      timeInterval\n      limit\n      enabled\n    }\n    loginFailCheck {\n      timeInterval\n      limit\n      enabled\n    }\n    changePhoneStrategy {\n      verifyOldPhone\n    }\n    changeEmailStrategy {\n      verifyOldEmail\n    }\n    qrcodeLoginStrategy {\n      qrcodeExpiresAfter\n      returnFullUserInfo\n      allowExchangeUserInfoFromBrowser\n      ticketExpiresAfter\n    }\n    app2WxappLoginStrategy {\n      ticketExpriresAfter\n      ticketExchangeUserInfoNeedSecret\n    }\n    whitelist {\n      phoneEnabled\n      emailEnabled\n      usernameEnabled\n    }\n    customSMSProvider {\n      enabled\n      provider\n      config\n    }\n    packageType\n    useCustomUserStore\n    loginRequireEmailVerified\n    verifyCodeLength\n  }\n}\n\",\n    \"variables\":{\n        \"userpoolDocument\":\"\nquery userpool {\n  userpool {\n    id\n    name\n    domain\n    description\n    secret\n    jwtSecret\n    ownerId\n    userpoolTypes {\n      code\n      name\n      description\n      image\n      sdks\n    }\n    logo\n    createdAt\n    updatedAt\n    emailVerifiedDefault\n    sendWelcomeEmail\n    registerDisabled\n    appSsoEnabled\n    showWxQRCodeWhenRegisterDisabled\n    allowedOrigins\n    tokenExpiresAfter\n    isDeleted\n    frequentRegisterCheck {\n      timeInterval\n      limit\n      enabled\n    }\n    loginFailCheck {\n      timeInterval\n      limit\n      enabled\n    }\n    changePhoneStrategy {\n      verifyOldPhone\n    }\n    changeEmailStrategy {\n      verifyOldEmail\n    }\n    qrcodeLoginStrategy {\n      qrcodeExpiresAfter\n      returnFullUserInfo\n      allowExchangeUserInfoFromBrowser\n      ticketExpiresAfter\n    }\n    app2WxappLoginStrategy {\n      ticketExpriresAfter\n      ticketExchangeUserInfoNeedSecret\n    }\n    whitelist {\n      phoneEnabled\n      emailEnabled\n      usernameEnabled\n    }\n    customSMSProvider {\n      enabled\n      provider\n      config\n    }\n    packageType\n    useCustomUserStore\n    loginRequireEmailVerified\n    verifyCodeLength\n  }\n}\n\"\n    }\n}").toJSONString().getBytes();
            os.write(bytes);
            os.flush();
            os.close();
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                res = Util.getStringFromStream(con.getInputStream());
                response = (AuthingResult)JSON.parseObject((String)res, (TypeReference)new TypeReference<AuthingResult<UserPoolDetail>>(){}, (Feature[])new Feature[0]);
                if (response == null || response.getData() == null || ((UserPoolDetail)response.getData()).getUserPool() == null) {
                    logger.error("Get user pool info failed, response: {}", (Object)response);
                    return null;
                }
            } else {
                res = Util.getStringFromStream(con.getErrorStream());
                logger.error("Get user pool info failed. Status code:" + responseCode + " Error:" + res);
                return null;
            }
            String ownerId = ((UserPoolDetail)response.getData()).getUserPool().getOwnerId();
            cooperatorIds.add(ownerId);
        }
        catch (Exception e) {
            logger.error("Get user pool info failed:", (Throwable)e);
        }
        return cooperatorIds.contains(userId);
    }

    static {
        sSetCookieOnTopDomain = true;
        sIncludeIDTokenInCookie = true;
        sUseDynamicAppInfo = false;
        sDomainAppInfoRegistry = new ConcurrentHashMap<String, AppInfo>();
        sCache = new ConcurrentHashMap<String, AuthInfo>();
        cleanCacheTask = new CleanCacheTask();
        timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)cleanCacheTask, 0L, TimeUnit.HOURS.toMillis(1L));
    }

    private static class CleanCacheTask
    extends TimerTask {
        private CleanCacheTask() {
        }

        @Override
        public void run() {
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (cal.get(11) == 3) {
                StatsUtil.trace();
            }
            try {
                long now = System.currentTimeMillis();
                for (Map.Entry entry : sCache.entrySet()) {
                    AuthInfo cache = (AuthInfo)entry.getValue();
                    if (now - cache.getLastValidTime() <= sCacheValidDuration) continue;
                    sCache.remove(entry.getKey());
                }
            }
            catch (Exception ex) {
                logger.error("Error when clean cache " + ex.getMessage());
            }
        }
    }
}

