/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.internal;

import cn.authing.internal.Base64;
import cn.authing.internal.Util;
import com.alibaba.fastjson.JSON;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jwk {
    private static final Logger logger = LoggerFactory.getLogger(Jwk.class);
    private ArrayList<Key> keys;
    private ArrayList<PublicKey> publicKey;

    static Jwk create(String url) {
        try {
            URL obj = new URL(url);
            HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
            con.setConnectTimeout(10000);
            int code = con.getResponseCode();
            if (code == 200) {
                String res = Util.getStringFromStream(con.getInputStream());
                Jwk jwk = (Jwk)JSON.parseObject((String)res, Jwk.class);
                jwk.generatePublicKey();
                return jwk;
            }
            logger.error("init Jwk failed. jwks endpoint:" + url + " status code:" + code);
        }
        catch (Exception e) {
            logger.error("init Jwk failed. jwks endpoint:" + url);
        }
        return null;
    }

    private void generatePublicKey() {
        KeyFactory keyFactory;
        if (this.keys == null || this.keys.size() == 0) {
            return;
        }
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return;
        }
        this.publicKey = new ArrayList();
        for (Key key : this.keys) {
            try {
                String n = key.getN();
                String e = key.getE();
                BigInteger modulus = new BigInteger(1, Base64.getUrlDecoder().decode(n));
                BigInteger exponent = new BigInteger(1, Base64.getUrlDecoder().decode(e));
                this.publicKey.add(keyFactory.generatePublic(new RSAPublicKeySpec(modulus, exponent)));
            }
            catch (InvalidKeySpecException e) {
                e.printStackTrace();
            }
        }
    }

    public ArrayList<Key> getKeys() {
        return this.keys;
    }

    public void setKeys(ArrayList<Key> keys) {
        this.keys = keys;
    }

    static DecodedJWT verifyToken(String idToken, Jwk jwk, String appSecret) {
        if (idToken == null || jwk == null || jwk.publicKey == null) {
            return null;
        }
        DecodedJWT jwt = JWT.decode((String)idToken);
        if ("HS256".equalsIgnoreCase(jwt.getAlgorithm())) {
            try {
                Algorithm algorithm = Algorithm.HMAC256((String)appSecret);
                algorithm.verify(jwt);
                return jwt;
            }
            catch (SignatureVerificationException e) {
                return null;
            }
        }
        for (int i = 0; i < jwk.publicKey.size(); ++i) {
            try {
                if ("RS256".equalsIgnoreCase(jwt.getAlgorithm())) {
                    Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.publicKey.get(i)), null);
                    algorithm.verify(jwt);
                }
                return jwt;
            }
            catch (SignatureVerificationException e) {
                continue;
            }
        }
        return null;
    }

    private static class Key {
        private String n;
        private String e;

        private Key() {
        }

        public String getN() {
            return this.n;
        }

        public void setN(String n) {
            this.n = n;
        }

        public String getE() {
            return this.e;
        }

        public void setE(String e) {
            this.e = e;
        }
    }
}

