/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.http;

import cn.authing.core.graphql.GraphQLResponse;
import cn.authing.core.http.Call;
import cn.authing.core.http.Callback;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B>\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015H\u0016J\r\u0010\u0016\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcn/authing/core/http/HttpCall;", "TData", "TResult", "Lcn/authing/core/http/Call;", "call", "Lokhttp3/Call;", "adapter", "Lcom/google/gson/TypeAdapter;", "resolver", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "data", "(Lokhttp3/Call;Lcom/google/gson/TypeAdapter;Lkotlin/jvm/functions/Function1;)V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "cancel", "", "enqueue", "callback", "Lcn/authing/core/http/Callback;", "execute", "()Ljava/lang/Object;", "isCanceled", "", "isExecuted", "request", "Lokhttp3/Request;", "java-core"})
public final class HttpCall<TData, TResult>
implements Call<TData, TResult> {
    @NotNull
    private final okhttp3.Call call;
    @NotNull
    private final TypeAdapter<TData> adapter;
    @NotNull
    private final Function1<TData, TResult> resolver;
    private final Gson gson;

    public HttpCall(@NotNull okhttp3.Call call, @NotNull TypeAdapter<TData> adapter, @NotNull Function1<? super TData, ? extends TResult> resolver) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull(adapter, (String)"adapter");
        Intrinsics.checkParameterIsNotNull(resolver, (String)"resolver");
        this.call = call;
        this.adapter = adapter;
        this.resolver = resolver;
        this.gson = new GsonBuilder().create();
    }

    @Override
    public TResult execute() throws IOException {
        ResponseBody responseBody;
        Response response = this.call.execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody2 = response.body();
            String body = responseBody2 == null ? null : responseBody2.string();
            Object data = this.adapter.fromJson(body);
            return (TResult)this.resolver.invoke(data);
        }
        throw new IOException("Unexpected code " + response + '\n' + ((responseBody = response.body()) == null ? null : responseBody.string()));
    }

    @Override
    public void enqueue(@NotNull Callback<TResult> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        okhttp3.Callback callbackWrapper2 = new okhttp3.Callback(this, callback){
            final /* synthetic */ HttpCall<TData, TResult> this$0;
            final /* synthetic */ Callback<TResult> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onResponse(@NotNull okhttp3.Call call, @NotNull Response response) {
                ResponseBody responseBody;
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    ResponseBody responseBody2;
                    throw new IOException("Unexpected code " + response + '\n' + ((responseBody2 = response.body()) == null ? null : responseBody2.string()));
                }
                Object data = HttpCall.access$getAdapter$p(this.this$0).fromJson((responseBody = response.body()) == null ? null : responseBody.string());
                this.$callback.onSuccess(HttpCall.access$getResolver$p(this.this$0).invoke(data));
            }

            public void onFailure(@NotNull okhttp3.Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$callback.onFailure(new GraphQLResponse.ErrorInfo(500, e.getMessage(), null, 4, null));
            }
        };
        this.call.enqueue(callbackWrapper2);
    }

    @Override
    public boolean isExecuted() {
        return this.call.isExecuted();
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @Override
    @Nullable
    public Request request() {
        return this.call.request();
    }

    public static final /* synthetic */ TypeAdapter access$getAdapter$p(HttpCall $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ Function1 access$getResolver$p(HttpCall $this) {
        return $this.resolver;
    }
}

