/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.graphql;

import cn.authing.core.graphql.GraphQLException;
import cn.authing.core.graphql.GraphQLResponse;
import cn.authing.core.http.Call;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003BD\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016H\u0016J\r\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00028\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/authing/core/graphql/GraphQLCall;", "TData", "TResult", "Lcn/authing/core/http/Call;", "call", "Lokhttp3/Call;", "adapter", "Lcom/google/gson/TypeAdapter;", "Lcn/authing/core/graphql/GraphQLResponse;", "resolver", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "data", "(Lokhttp3/Call;Lcom/google/gson/TypeAdapter;Lkotlin/jvm/functions/Function1;)V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "cancel", "", "enqueue", "callback", "Lcn/authing/core/http/Callback;", "execute", "()Ljava/lang/Object;", "isCanceled", "", "isExecuted", "request", "Lokhttp3/Request;", "java-core"})
public final class GraphQLCall<TData, TResult>
implements Call<TData, TResult> {
    @NotNull
    private final okhttp3.Call call;
    @NotNull
    private final TypeAdapter<GraphQLResponse<TData>> adapter;
    @NotNull
    private final Function1<TData, TResult> resolver;
    private final Gson gson;

    public GraphQLCall(@NotNull okhttp3.Call call, @NotNull TypeAdapter<GraphQLResponse<TData>> adapter, @NotNull Function1<? super TData, ? extends TResult> resolver) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull(adapter, (String)"adapter");
        Intrinsics.checkParameterIsNotNull(resolver, (String)"resolver");
        this.call = call;
        this.adapter = adapter;
        this.resolver = resolver;
        this.gson = new GsonBuilder().create();
    }

    @Override
    public TResult execute() throws IOException, GraphQLException {
        ResponseBody responseBody;
        Response response = this.call.execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody2 = response.body();
            String body = responseBody2 == null ? null : responseBody2.string();
            Object object = this.adapter.fromJson(body);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"adapter.fromJson(body)");
            GraphQLResponse graphQLResponse = (GraphQLResponse)object;
            if (graphQLResponse.getErrors() != null) {
                object = graphQLResponse.getErrors();
                boolean bl = false;
                if (!object.isEmpty()) {
                    object = this.gson.toJson(graphQLResponse.getErrors());
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.toJson(graphQLResponse.errors)");
                    throw new GraphQLException((String)object);
                }
            }
            Object t = graphQLResponse.getData();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            return (TResult)this.resolver.invoke(t);
        }
        throw new IOException(response.code() + ": " + response.message() + '\n' + ((responseBody = response.body()) == null ? null : responseBody.string()));
    }

    @Override
    public void enqueue(@NotNull cn.authing.core.http.Callback<TResult> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Callback callbackWrapper2 = new Callback(this, callback){
            final /* synthetic */ GraphQLCall<TData, TResult> this$0;
            final /* synthetic */ cn.authing.core.http.Callback<TResult> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onResponse(@NotNull okhttp3.Call call, @NotNull Response response) {
                T t;
                Function1 function1;
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    ResponseBody responseBody;
                    Object object = GraphQLCall.access$getAdapter$p(this.this$0).fromJson((responseBody = response.body()) == null ? null : responseBody.string());
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"adapter.fromJson(response.body?.string())");
                    GraphQLResponse graphQLResponse = (GraphQLResponse)object;
                    if (graphQLResponse.getErrors() != null) {
                        object = graphQLResponse.getErrors();
                        boolean bl = false;
                        if (!object.isEmpty()) {
                            int n;
                            GraphQLResponse.ErrorInfo firstError = graphQLResponse.getErrors().get(0).getMessage();
                            GraphQLResponse.ErrorInfo errorInfo = firstError;
                            int n2 = errorInfo == null ? 500 : (n = errorInfo.getCode());
                            errorInfo = firstError;
                            String string = errorInfo == null ? null : errorInfo.getMessage();
                            errorInfo = firstError;
                            this.$callback.onFailure(new GraphQLResponse.ErrorInfo(n2, string, errorInfo == null ? null : errorInfo.getData()));
                            return;
                        }
                    }
                    function1 = GraphQLCall.access$getResolver$p(this.this$0);
                    t = graphQLResponse.getData();
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    throw new IOException(Intrinsics.stringPlus((String)"Unexpected code ", (Object)response));
                }
                this.$callback.onSuccess(function1.invoke(t));
            }

            public void onFailure(@NotNull okhttp3.Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$callback.onFailure(new GraphQLResponse.ErrorInfo(500, e.getMessage(), null, 4, null));
            }
        };
        this.call.enqueue(callbackWrapper2);
    }

    @Override
    public boolean isExecuted() {
        return this.call.isExecuted();
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @Override
    @Nullable
    public Request request() {
        return this.call.request();
    }

    public static final /* synthetic */ TypeAdapter access$getAdapter$p(GraphQLCall $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ Function1 access$getResolver$p(GraphQLCall $this) {
        return $this.resolver;
    }
}

