/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.sdk.java.client;

import cn.authing.sdk.java.bean.OpenapiRequest;
import cn.authing.sdk.java.bean.OpenapiResponse;
import cn.authing.sdk.java.bean.api.userpool.token.TokenGetRequest;
import cn.authing.sdk.java.bean.api.userpool.token.TokenGetResponse;
import cn.authing.sdk.java.client.AuthingBaseClient;
import cn.authing.sdk.java.exception.ClientExecuteException;
import cn.authing.sdk.java.util.EncryptUtils;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AuthingHttpClient
extends AuthingBaseClient {
    private static final Log log = LogFactory.get(AuthingHttpClient.class);
    private static final TypeReference<OpenapiResponse<JSONObject>> TYPE_REFERENCE = new TypeReference<OpenapiResponse<JSONObject>>(){};
    protected String accessToken;
    protected Long accessTokenExpiresAt;

    public AuthingHttpClient(String clientId, String clientSecret) {
        super(clientId, clientSecret);
    }

    public AuthingHttpClient(String clientId, String clientSecret, String appId, String appSecret) {
        super(clientId, clientSecret, appId, appSecret);
    }

    public AuthingHttpClient(String clientId, String clientSecret, String host, String appId, String appSecret) {
        super(clientId, clientSecret, host, appId, appSecret);
    }

    public AuthingHttpClient(String clientId, String clientSecret, String host, String userPoolId, String appId, String appSecret) {
        super(clientId, clientSecret, host, userPoolId, appId, appSecret);
    }

    public <R> R execute(OpenapiRequest request, Class<R> clazz) {
        return this.execute(request, clazz, UUID.randomUUID().toString());
    }

    public <R> R execute(OpenapiRequest request, Class<R> clazz, String traceId) {
        long start = System.currentTimeMillis();
        String method = request.getMethod();
        String responseBody = null;
        try {
            String path = "/openapi/router/rest" + this.renderPath(request.getPath(), request.getPathVariables());
            String requestBody = JSONUtil.toJsonStr(request.getRequestBody());
            String url = this.endpoint + path + this.buildQueryString(request.getQueryParams());
            if (log.isDebugEnabled()) {
                log.debug("{} -> execute method [{}] url: {}, request body: {}", new Object[]{traceId, method, url, requestBody});
            }
            HttpResponse httpResponse = ((HttpRequest)((HttpRequest)new HttpRequest(url).method(this.getMethod(request.getHttpMethod())).body(requestBody).headerMap(this.buildHeaders(request, path, requestBody, traceId), Boolean.FALSE.booleanValue())).header(Header.ACCEPT, "application/json")).execute();
            responseBody = httpResponse.body();
            OpenapiResponse response = (OpenapiResponse)JSONUtil.toBean((String)responseBody, TYPE_REFERENCE, (boolean)Boolean.FALSE);
            this.checkResponse(response);
            if (log.isDebugEnabled()) {
                log.debug("{} -> execute method [{}] response body: {}, cost: {} ms", new Object[]{traceId, method, responseBody, System.currentTimeMillis() - start});
            }
            JSONObject data = (JSONObject)response.getData();
            return (R)JSONUtil.toBean((JSONObject)data, clazz);
        }
        catch (ClientExecuteException e) {
            if (log.isErrorEnabled()) {
                log.error("{} -> execute method [{}] response body: {}, cost: {}", new Object[]{traceId, method, responseBody, System.currentTimeMillis() - start, e});
            }
            throw e;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("{} -> execute method [{}] response body: {}, cost: {}", new Object[]{traceId, method, responseBody, System.currentTimeMillis() - start, e});
            }
            throw new ClientExecuteException(e);
        }
    }

    private Method getMethod(String httpMethod) {
        switch (httpMethod) {
            case "GET": {
                return Method.GET;
            }
            case "POST": {
                return Method.POST;
            }
            case "HEAD": {
                return Method.HEAD;
            }
            case "OPTIONS": {
                return Method.OPTIONS;
            }
            case "PUT": {
                return Method.PUT;
            }
            case "DELETE": {
                return Method.DELETE;
            }
            case "TRACE": {
                return Method.TRACE;
            }
            case "CONNECT": {
                return Method.CONNECT;
            }
            case "PATCH": {
                return Method.PATCH;
            }
        }
        throw new IllegalArgumentException("method not found!");
    }

    private String renderPath(String path, Map<String, String> pathVariables) {
        if (pathVariables.isEmpty()) {
            return path;
        }
        char[] chars = path.toCharArray();
        StringBuilder realPathSb = new StringBuilder();
        StringBuilder keySb = new StringBuilder();
        boolean b = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '$' && i + 1 < chars.length && chars[i + 1] == '{') {
                b = true;
                ++i;
                keySb.delete(0, keySb.length());
                continue;
            }
            if (b && chars[i] == '}') {
                String key = keySb.toString();
                realPathSb.append(pathVariables.get(key));
                b = false;
                continue;
            }
            if (b) {
                keySb.append(chars[i]);
                continue;
            }
            realPathSb.append(chars[i]);
        }
        return realPathSb.toString();
    }

    private Map<String, String> buildHeaders(OpenapiRequest request, String path, String body, String traceId) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("method", request.getMethod());
        requestHeaders.put("client_id", this.clientId);
        requestHeaders.put("version", "1.0");
        requestHeaders.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestHeaders.put("format", "json");
        requestHeaders.put("sync", "sync");
        requestHeaders.put("trace_id", traceId);
        requestHeaders.put("ext", this.buildExt(request, traceId));
        requestHeaders.put("source", "sdk:java:5.0.64");
        requestHeaders.put("sign", this.generateSign(request, requestHeaders, path, body));
        return requestHeaders;
    }

    private String buildExt(OpenapiRequest request, String traceId) {
        Map<String, String> requestHeaders = request.getRequestHeaders();
        HashMap<String, String> ext = new HashMap<String, String>();
        ext.put("Authorization", "Bearer " + this.getAccessToken(request, traceId));
        ext.put("x-authing-userpool-id", this.userPoolId);
        ext.put("x-authing-request-from", "Java");
        ext.put("x-authing-sdk-version", "sdk:java:5.0.64");
        ext.put("x-authing-app-id", this.appId);
        if (requestHeaders != null) {
            ext.putAll(requestHeaders);
        }
        return JSONUtil.toJsonStr(ext);
    }

    private String getAccessToken(OpenapiRequest request, String traceId) {
        if (this.accessToken != null && this.accessTokenExpiresAt != null && this.accessTokenExpiresAt > System.currentTimeMillis() + 3600000L) {
            return this.accessToken;
        }
        if ("authing.userpool.token.get".equals(request.getMethod())) {
            return null;
        }
        TokenGetRequest req = new TokenGetRequest();
        req.setUserPoolId(this.userPoolId);
        req.setSecret(this.userPoolSecret);
        TokenGetResponse resp = this.execute(req, TokenGetResponse.class, traceId);
        System.out.println("get token success:" + JSONUtil.toJsonStr((Object)resp));
        this.accessTokenExpiresAt = resp.getExp() != null ? Long.valueOf(resp.getExp().longValue() * 1000L) : null;
        this.accessToken = resp.getAccessToken();
        return this.accessToken;
    }

    private String buildQueryString(Map<String, String> queryParams) {
        StringBuilder sb = new StringBuilder();
        if (queryParams.isEmpty()) {
            return "";
        }
        sb.append("?");
        queryParams.forEach((key, value) -> {
            if (value != null) {
                sb.append((String)key).append("=").append((String)value).append("&");
            }
        });
        return sb.toString();
    }

    private String generateSign(OpenapiRequest request, Map<String, String> requestHeaders, String path, String body) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.clientId);
        sb.append(request.getHttpMethod().toLowerCase());
        requestHeaders.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            if (entry.getValue() != null) {
                sb.append((String)entry.getKey()).append((String)entry.getValue());
            }
        });
        try {
            sb.append(URLEncoder.encode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        request.getQueryParams().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            if (entry.getValue() != null) {
                sb.append((String)entry.getKey()).append((String)entry.getValue());
            }
        });
        if (body != null) {
            sb.append(body);
        }
        sb.append(this.clientSecret);
        return EncryptUtils.md5Encrypt(sb.toString());
    }

    private <R> void checkResponse(OpenapiResponse<R> response) {
        if (response == null) {
            throw new RuntimeException("response is null");
        }
        String code = response.getCode();
        if ("1_00_0000".equals(code)) {
            return;
        }
        throw new ClientExecuteException(response.getCode(), response.getMessage());
    }
}

