/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.init;

import cn.authing.core.business.AuthingResponse;
import cn.authing.core.business.HttpHelper;
import cn.authing.core.business.ImportantParam;
import cn.authing.core.business.Platform;
import cn.authing.core.http.Call;
import cn.authing.core.http.Callback;
import cn.authing.core.init.InitResult;
import cn.authing.core.param.InitParam;
import cn.authing.core.result.ErrorInfo;
import cn.authing.core.utils.AuthingUtils;
import com.google.gson.reflect.TypeToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\b\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\"\u001e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0001@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0014"}, d2={"<set-?>", "", "hasInit", "getHasInit", "()Z", "destroy", "", "getNonce", "", "init", "helper", "Lcn/authing/core/business/HttpHelper;", "param", "Lcn/authing/core/param/InitParam;", "onFailureCallback", "error", "Lcn/authing/core/result/ErrorInfo;", "onSuccessCallback", "result", "Lcn/authing/core/init/InitResult;", "core"})
public final class InitUtilsKt {
    private static boolean hasInit;

    public static final boolean getHasInit() {
        return hasInit;
    }

    public static final void init(@NotNull HttpHelper helper, @NotNull InitParam param) {
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        String clientId = param.getClientId();
        ImportantParam.INSTANCE.setClientId(clientId);
        if (param.getOAuthHost() != null) {
            String string = param.getOAuthHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"param.oAuthHost");
            AuthingUtils.INSTANCE.setURL_OAUTH(string);
        }
        if (param.getUserHost() != null) {
            String string = param.getUserHost();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"param.userHost");
            AuthingUtils.INSTANCE.setURL_USER(string);
        }
        Call createAuthingCall2 = HttpHelper.createAuthingCall$default(helper, AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<InitResult>>(){}, param, null, 8, null);
        if (Intrinsics.areEqual(Platform.Android.class, Platform.Companion.getPlatform().getClass())) {
            createAuthingCall2.enqueue(new Callback<InitResult>(){

                public void onFailure(@Nullable ErrorInfo error) {
                    InitUtilsKt.access$onFailureCallback(error);
                }

                public void onSuccess(@Nullable InitResult result) {
                    InitUtilsKt.access$onSuccessCallback(result);
                }
            });
        } else {
            InitResult result = (InitResult)createAuthingCall2.execute();
            if (result == null) {
                InitUtilsKt.onFailureCallback(null);
            } else {
                InitUtilsKt.onSuccessCallback(result);
            }
        }
    }

    private static final void onSuccessCallback(InitResult result) {
        block3: {
            block2: {
                if (hasInit) break block2;
                InitResult initResult = result;
                if ((initResult != null ? initResult.getAccessToken() : null) != null) break block3;
            }
            return;
        }
        ImportantParam.INSTANCE.setOwnerToken(result.getAccessToken());
        String string = "Authing init success, accessToken=" + result.getAccessToken();
        boolean bl = false;
        System.out.println((Object)string);
        hasInit = true;
    }

    private static final void onFailureCallback(ErrorInfo error) {
        ErrorInfo errorInfo = error;
        ErrorInfo errorInfo2 = error;
        String string = "Authing init fail, code-" + (errorInfo != null ? Integer.valueOf(errorInfo.getCode()) : null) + ", msg-" + (errorInfo2 != null ? errorInfo2.getMessage() : null);
        boolean bl = false;
        System.out.println((Object)string);
    }

    public static final void destroy() {
        hasInit = false;
    }

    public static final int getNonce() {
        return (int)Math.ceil(Math.random() * Math.pow(10.0, 6.0));
    }

    public static final /* synthetic */ void access$onFailureCallback(ErrorInfo error) {
        InitUtilsKt.onFailureCallback(error);
    }

    public static final /* synthetic */ void access$onSuccessCallback(InitResult result) {
        InitUtilsKt.onSuccessCallback(result);
    }
}

