/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.business;

import cn.authing.core.business.AuthingResponse;
import cn.authing.core.business.HttpHelper;
import cn.authing.core.business.ImportantParam;
import cn.authing.core.http.Call;
import cn.authing.core.param.SendResetPasswordEmailParam;
import cn.authing.core.param.SendVerifyEmailParam;
import cn.authing.core.param.VerifyResetPasswordCodeParam;
import cn.authing.core.result.Result;
import cn.authing.core.service.VerifyService;
import cn.authing.core.utils.AuthingUtils;
import com.google.gson.reflect.TypeToken;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcn/authing/core/business/VerifyServiceImpl;", "Lcn/authing/core/service/VerifyService;", "helper", "Lcn/authing/core/business/HttpHelper;", "(Lcn/authing/core/business/HttpHelper;)V", "sendPhoneVerifyCode", "Lcn/authing/core/http/Call;", "Lcn/authing/core/result/Result;", "phoneNumber", "", "sendResetPasswordEmail", "param", "Lcn/authing/core/param/SendResetPasswordEmailParam;", "sendVerifyEmail", "Lcn/authing/core/param/SendVerifyEmailParam;", "verifyResetPasswordCode", "Lcn/authing/core/param/VerifyResetPasswordCodeParam;", "core"})
public final class VerifyServiceImpl
implements VerifyService {
    private final HttpHelper helper;

    @Override
    @NotNull
    public Call<Result> sendPhoneVerifyCode(@NotNull String phoneNumber) {
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        String builder = "https://users.authing.cn/send_smscode/" + phoneNumber + "/" + ImportantParam.INSTANCE.getClientId();
        return this.helper.createNormalCall(builder, Result.class);
    }

    @Override
    @NotNull
    public Call<Result> sendResetPasswordEmail(@NotNull SendResetPasswordEmailParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createAuthingCall(AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<Result>>(){}, param, null);
    }

    @Override
    @NotNull
    public Call<Result> verifyResetPasswordCode(@NotNull VerifyResetPasswordCodeParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createAuthingCall(AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<Result>>(){}, param, null);
    }

    @Override
    @NotNull
    public Call<Result> sendVerifyEmail(@NotNull SendVerifyEmailParam param) {
        Intrinsics.checkParameterIsNotNull((Object)param, (String)"param");
        return this.helper.createAuthingCall(AuthingUtils.INSTANCE.getURL_USER(), (TypeToken)new TypeToken<AuthingResponse<Result>>(){}, param, ImportantParam.INSTANCE.getOwnerToken());
    }

    public VerifyServiceImpl(@NotNull HttpHelper helper) {
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        this.helper = helper;
    }
}

