/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core;

import cn.authing.core.business.HttpHelper;
import cn.authing.core.business.OAuthServiceImpl;
import cn.authing.core.business.PermissionServiceImpl;
import cn.authing.core.business.UserManageServiceImpl;
import cn.authing.core.business.UserServiceImpl;
import cn.authing.core.business.VerifyServiceImpl;
import cn.authing.core.init.InitUtilsKt;
import cn.authing.core.param.InitParam;
import cn.authing.core.service.OAuthService;
import cn.authing.core.service.PermissionService;
import cn.authing.core.service.UserManageService;
import cn.authing.core.service.UserService;
import cn.authing.core.service.VerifyService;
import org.jetbrains.annotations.NotNull;

public class Authing {
    private static UserService userService;
    private static UserManageService userManageService;
    private static OAuthService oAuthService;
    private static VerifyService verifyService;
    private static PermissionService permissionService;

    public static void init(@NotNull InitParam param) {
        if (InitUtilsKt.getHasInit()) {
            return;
        }
        HttpHelper helper = new HttpHelper();
        InitUtilsKt.init(helper, param);
        Authing.initService(helper);
    }

    private static void initService(HttpHelper helper) {
        userService = new UserServiceImpl(helper);
        userManageService = new UserManageServiceImpl(helper);
        oAuthService = new OAuthServiceImpl(helper);
        verifyService = new VerifyServiceImpl(helper);
        permissionService = new PermissionServiceImpl(helper);
    }

    public static void destroy() {
        userService = null;
        userManageService = null;
        oAuthService = null;
        verifyService = null;
        permissionService = null;
        InitUtilsKt.destroy();
    }

    public static UserManageService getUserManageService() {
        return userManageService;
    }

    public static UserService getUserService() {
        return userService;
    }

    public static OAuthService getOAuthService() {
        return oAuthService;
    }

    public static VerifyService getVerifyService() {
        return verifyService;
    }

    public static PermissionService getPermissionService() {
        return permissionService;
    }
}

