package cn.authing.guard.flow;

import static cn.authing.guard.activity.AuthActivity.RC_LOGIN;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import cn.authing.guard.Authing;
import cn.authing.guard.R;
import cn.authing.guard.activity.AuthActivity;
import cn.authing.guard.activity.IndexAuthActivity;
import cn.authing.guard.activity.UserProfileActivity;
import cn.authing.guard.data.UserInfo;
import cn.authing.guard.util.ToastUtil;

public class AuthFlow implements Serializable {

    //    public static final String KEY_PHONE_NUMBER = "phoneNumber";
    public static final String KEY_ACCOUNT = "account";
    public static final String KEY_USER_INFO = "user_info";
    public static final String KEY_MFA_PHONE = "mfa_phone";
    public static final String KEY_MFA_PHONE_COUNTRY_CODE = "mfa_phoneCountryCode";
    public static final String KEY_MFA_EMAIL = "mfa_email";
    public static final String KEY_MFA_RECOVERY_CODE = "mfa_recovery_code";
    public static final String KEY_EXTENDED_FIELDS = "extended_fields";
    public static final String KEY_SOCIAL_ACCOUNT_BIND_CODE = "social_account_bind_code";
    public static final String KEY_PUSH_DATA = "push_data";
    public static final String KEY_BIOMETRIC_BIND = "biometric_bind";
    private Map<String, Object> data = new HashMap<>();

    private int indexLayoutId;
    private int socialLoginLayoutId;
    private int registerLayoutId;
    private int forgotPasswordLayoutId;
    private int resetPasswordByEmailLayoutId;
    private int resetPasswordByPhoneLayoutId;
    private int resetPasswordLayoutId;
    private int resetPasswordSuccessLayoutId;
    private int accountCancellationLayoutId;
    private int authHelpLayoutId;

    // MFA
    private int[] mfaPhoneLayoutIds;
    private int mfaPhoneCurrentStep;
    private int[] mfaEmailLayoutIds;
    private int mfaEmailCurrentStep; // index starting from 0
    //private int mfaOTPLayoutId;
    private int[] mfaOTPLayoutIds;
    private int mfaOTPCurrentStep; // index starting from 0
    private int[] mfaRecoveryLayoutIds;
    private int mfaRecoveryCurrentStep;
    private int[] mfaFaceLayoutIds;
    private int mfaFaceCurrentStep; // index starting from 0
    // user info complete
    private int[] userInfoCompleteLayoutIds;
    private int userInfoCompleteItemNormal;
    private int userInfoCompleteItemEmail;
    private int userInfoCompleteItemPhone;
    private int userInfoCompleteItemSelect;
    private int userInfoCompleteItemDatePicker;
    //reset password
    private int resetPasswordFirstLoginLayoutId;
    private int verifyEmailSendSuccessLayoutId;
    //社会化登录询问绑定
    private int[] socialBindAccountLayoutIds;
    private int socialBindAccountCurrentStep;
    //push
    private int pushLoginLayoutId;
    private int pushLoginSuccessLayoutId;
    //biometric
    private int biometricAccountBindLayoutId;
    private int biometricAccountBindSuccessLayoutId;

    private String scope = "openid profile email phone username address offline_access role extended_fields";
    private boolean skipConsent;
    // save confirmed data across Guard. e.g. Phone Number, Email
    private boolean syncData = true;
    private static AuthFlowUIConfig uiConfig;


    public interface Callback<T> extends Serializable {
        void call(Context context, int code, String message, T userInfo);
    }

    private Callback<UserInfo> authCallback;

    public static AuthFlow start(Activity context) {
        return start(context, R.layout.authing_login);
    }

    public static AuthFlow start(Activity context, AuthFlowUIConfig uiConfig) {
        if (uiConfig != null && uiConfig.getContentMode() == AuthFlowUIConfig.ContentMode.MIDDLE){
            return start(context, R.layout.authing_login_middle, uiConfig);
        }
        return start(context, R.layout.authing_login, uiConfig);
    }

    public static AuthFlow startWeb(Activity context) {
        return start(context, R.layout.authing_login_web);
    }

    public static AuthFlow start(Activity activity, int layoutId) {
        return start(activity, layoutId, null);
    }

    public static AuthFlow start(Activity activity, int layoutId, AuthFlowUIConfig uiConfig) {
        final AuthFlow flow = new AuthFlow();
        flow.setUiConfig(uiConfig);
        flow.indexLayoutId = layoutId;

        if (Authing.getAppId() == null) {
            ToastUtil.showCenterWarning(activity, "请先设置appId");
            Log.e("AuthFlow", activity.getString(R.string.authing_uninitialized));
        } else {
            new Thread() {
                public void run() {
                    if (activity == null){
                        return;
                    }
                    activity.runOnUiThread(() -> {
                        Intent intent = new Intent(activity, IndexAuthActivity.class);
                        intent.putExtra(AuthActivity.AUTH_FLOW, flow);
                        activity.startActivityForResult(intent, RC_LOGIN);
                    });
                }
            }.start();
        }

        return flow;
    }

    public static void showUserProfile(Activity activity) {
        Intent intent = new Intent(activity, UserProfileActivity.class);
        activity.startActivity(intent);
    }

    public Map<String, Object> getData() {
        return data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public static void put(Context context, String key, String value) {
        if (context instanceof AuthActivity) {
            AuthActivity activity = (AuthActivity) context;
            AuthFlow flow = activity.getFlow();
            flow.data.put(key, value);
        }
    }

    public static Object get(Context context, String key) {
        if (context instanceof AuthActivity) {
            AuthActivity activity = (AuthActivity) context;
            AuthFlow flow = activity.getFlow();
            if (flow != null) {
                return flow.data.get(key);
            }
        }
        return null;
    }

    public static String getAccount(Context context) {
        return (String) get(context, KEY_ACCOUNT);
    }

    public int getIndexLayoutId() {
        if (indexLayoutId == 0) {
            return R.layout.authing_login;
        } else {
            return indexLayoutId;
        }
    }

    public int getSocialLoginLayoutId() {
        if (socialLoginLayoutId == 0) {
            return R.layout.authing_social_login;
        } else {
            return socialLoginLayoutId;
        }
    }

    public AuthFlow setSocialLoginLayoutId(int socialLoginLayoutId) {
        this.socialLoginLayoutId = socialLoginLayoutId;
        return this;
    }

    public int getRegisterLayoutId() {
        if (registerLayoutId == 0) {
            if (uiConfig != null && uiConfig.getContentMode() == AuthFlowUIConfig.ContentMode.MIDDLE){
                return R.layout.authing_register_middle;
            }
            return R.layout.authing_register;
        } else {
            return registerLayoutId;
        }
    }

    public AuthFlow setRegisterLayoutId(int registerLayoutId) {
        this.registerLayoutId = registerLayoutId;
        return this;
    }

    public int getForgotPasswordLayoutId() {
        if (forgotPasswordLayoutId == 0) {
            return R.layout.authing_forgot_password;
        } else {
            return forgotPasswordLayoutId;
        }
    }

    public AuthFlow setForgotPasswordLayoutId(int forgotPasswordLayoutId) {
        this.forgotPasswordLayoutId = forgotPasswordLayoutId;
        return this;
    }

    public int getRestPasswordLayoutId() {
        if (resetPasswordLayoutId == 0) {
            return R.layout.authing_reset_password;
        } else {
            return resetPasswordLayoutId;
        }
    }

    public AuthFlow setResetPasswordLayoutId(int resetPasswordLayoutId) {
        this.resetPasswordLayoutId = resetPasswordLayoutId;
        return this;
    }

    public int getRestPasswordSuccessLayoutId() {
        if (resetPasswordSuccessLayoutId == 0) {
            return R.layout.authing_reset_password_success;
        } else {
            return resetPasswordSuccessLayoutId;
        }
    }

    public AuthFlow setResetPasswordSuccessLayoutId(int resetPasswordSuccessLayoutId) {
        this.resetPasswordSuccessLayoutId = resetPasswordSuccessLayoutId;
        return this;
    }

    public int getResetPasswordByEmailLayoutId() {
        if (resetPasswordByPhoneLayoutId == 0) {
            return R.layout.authing_reset_password_by_email;
        } else {
            return resetPasswordByEmailLayoutId;
        }
    }

    public AuthFlow setResetPasswordByEmailLayoutId(int resetPasswordByEmailLayoutId) {
        this.resetPasswordByEmailLayoutId = resetPasswordByEmailLayoutId;
        return this;
    }

    public int getResetPasswordByPhoneLayoutId() {
        if (resetPasswordByPhoneLayoutId == 0) {
            return R.layout.authing_reset_password_by_phone;
        } else {
            return resetPasswordByPhoneLayoutId;
        }
    }

    public AuthFlow setResetPasswordByPhoneLayoutId(int resetPasswordByPhoneLayoutId) {
        this.resetPasswordByPhoneLayoutId = resetPasswordByPhoneLayoutId;
        return this;
    }

    public int getAccountCancellationLayoutId() {
        if (accountCancellationLayoutId == 0) {
            return R.layout.authing_delete_account;
        } else {
            return accountCancellationLayoutId;
        }
    }

    public AuthFlow setAccountCancellationLayoutId(int accountCancellationLayoutId) {
        this.accountCancellationLayoutId = accountCancellationLayoutId;
        return this;
    }

    public int getAuthHelpLayoutId() {
        if (authHelpLayoutId == 0) {
            return R.layout.authing_feedback;
        } else {
            return authHelpLayoutId;
        }
    }

    public AuthFlow setAuthHelpLayoutId(int authHelpLayoutId) {
        this.authHelpLayoutId = authHelpLayoutId;
        return this;
    }

    public int[] getMfaPhoneLayoutIds() {
        if (mfaPhoneLayoutIds == null) {
            return new int[]{R.layout.authing_mfa_phone_bind_tip,
                    R.layout.authing_mfa_phone_bind,
                    R.layout.authing_mfa_phone_bind_success,
                    R.layout.authing_mfa_phone_verify};
        }
        return mfaPhoneLayoutIds;
    }

    public void setMfaPhoneLayoutIds(int[] mfaPhoneLayoutIds) {
        this.mfaPhoneLayoutIds = mfaPhoneLayoutIds;
    }

    public void setMfaPhoneLayoutId(int mfaPhoneLayoutId) {
        this.mfaPhoneLayoutIds = new int[mfaPhoneLayoutId];
    }

    public int getMfaPhoneCurrentStep() {
        return mfaPhoneCurrentStep;
    }

    public void setMfaPhoneCurrentStep(int mfaPhoneCurrentStep) {
        this.mfaPhoneCurrentStep = mfaPhoneCurrentStep;
    }

    public int[] getMfaEmailLayoutIds() {
        if (mfaEmailLayoutIds == null) {
            return new int[]{R.layout.authing_mfa_email_bind_tip,
                    R.layout.authing_mfa_email_bind,
                    R.layout.authing_mfa_email_bind_success,
                    R.layout.authing_mfa_email_verify};
        }
        return mfaEmailLayoutIds;
    }

    public void setMfaEmailLayoutIds(int[] mfaEmailLayoutIds) {
        this.mfaEmailLayoutIds = mfaEmailLayoutIds;
    }

    public void setMfaBindEmailLayoutId(int mfaBindEmailLayoutId) {
        this.mfaEmailLayoutIds = new int[mfaBindEmailLayoutId];
    }

    public int getMfaEmailCurrentStep() {
        return mfaEmailCurrentStep;
    }

    public void setMfaEmailCurrentStep(int mfaEmailCurrentStep) {
        this.mfaEmailCurrentStep = mfaEmailCurrentStep;
    }

    public int[] getUserInfoCompleteLayoutIds() {
        if (userInfoCompleteLayoutIds == null) {
            return new int[]{R.layout.authing_userinfo_complete};
        }
        return userInfoCompleteLayoutIds;
    }

    public int[] getMfaOTPLayoutIds() {
        if (mfaOTPLayoutIds == null) {
            return new int[]{R.layout.authing_mfa_otp_bind_tip,
                    R.layout.authing_mfa_otp_bind,
                    R.layout.authing_mfa_otp_bind_success,
                    R.layout.authing_mfa_otp_verify};
        }
        return mfaOTPLayoutIds;
    }

    public void setMfaOTPLayoutIds(int[] mfaOTPLayoutIds) {
        this.mfaOTPLayoutIds = mfaOTPLayoutIds;
    }

    public int getMfaOTPCurrentStep() {
        return mfaOTPCurrentStep;
    }

    public void setMfaOTPCurrentStep(int mfaOTPCurrentStep) {
        this.mfaOTPCurrentStep = mfaOTPCurrentStep;
    }

    public int[] getMfaRecoveryLayoutIds() {
        if (mfaRecoveryLayoutIds == null) {
            return new int[]{R.layout.authing_mfa_otp_recovery_0, R.layout.authing_mfa_otp_recovery_1};
        }
        return mfaRecoveryLayoutIds;
    }

    public void setMfaRecoveryLayoutIds(int[] mfaRecoveryLayoutIds) {
        this.mfaRecoveryLayoutIds = mfaRecoveryLayoutIds;
    }

    public int getMfaRecoveryCurrentStep() {
        return mfaRecoveryCurrentStep;
    }

    public void setMfaRecoveryCurrentStep(int mfaRecoveryCurrentStep) {
        this.mfaRecoveryCurrentStep = mfaRecoveryCurrentStep;
    }

    public int[] getMfaFaceLayoutIds() {
        if (mfaFaceLayoutIds == null) {
            return new int[]{R.layout.authing_mfa_face_bind_tip,
                    R.layout.authing_mfa_face_bind_before,
                    R.layout.authing_mfa_face_bind,
                    R.layout.authing_mfa_face_bind_success,
                    R.layout.authing_mfa_face_bind_failed,
                    R.layout.authing_mfa_face_verify_before,
                    R.layout.authing_mfa_face_verify,
                    R.layout.authing_mfa_face_verify_success,
                    R.layout.authing_mfa_face_verify_failed};
        }
        return mfaFaceLayoutIds;
    }

    public void setMfaFaceLayoutIds(int[] mfaFaceLayoutIds) {
        this.mfaFaceLayoutIds = mfaFaceLayoutIds;
    }

    public int getMfaFaceCurrentStep() {
        return mfaFaceCurrentStep;
    }

    public void setMfaFaceCurrentStep(int mfaFaceCurrentStep) {
        this.mfaFaceCurrentStep = mfaFaceCurrentStep;
    }

    public void setUserInfoCompleteLayoutIds(int[] userInfoCompleteLayoutIds) {
        this.userInfoCompleteLayoutIds = userInfoCompleteLayoutIds;
    }

    public void setUserInfoCompleteLayoutId(int userInfoCompleteLayoutId) {
        this.userInfoCompleteLayoutIds = new int[userInfoCompleteLayoutId];
    }

    public int getUserInfoCompleteItemNormal() {
        if (userInfoCompleteItemNormal == 0) {
            return R.layout.authing_userinfo_complete_item_normal;
        }
        return userInfoCompleteItemNormal;
    }

    public void setUserInfoCompleteItemNormal(int userInfoCompleteItemNormal) {
        this.userInfoCompleteItemNormal = userInfoCompleteItemNormal;
    }

    public int getUserInfoCompleteItemEmail() {
        if (userInfoCompleteItemEmail == 0) {
            return R.layout.authing_userinfo_complete_item_email;
        }
        return userInfoCompleteItemEmail;
    }

    public void setUserInfoCompleteItemEmail(int userInfoCompleteItemEmail) {
        this.userInfoCompleteItemEmail = userInfoCompleteItemEmail;
    }

    public int getUserInfoCompleteItemPhone() {
        if (userInfoCompleteItemPhone == 0) {
            return R.layout.authing_userinfo_complete_item_phone;
        }
        return userInfoCompleteItemPhone;
    }

    public void setUserInfoCompleteItemPhone(int userInfoCompleteItemPhone) {
        this.userInfoCompleteItemPhone = userInfoCompleteItemPhone;
    }

    public int getUserInfoCompleteItemSelect() {
        if (userInfoCompleteItemSelect == 0) {
            return R.layout.authing_userinfo_complete_item_select;
        }
        return userInfoCompleteItemSelect;
    }

    public void setUserInfoCompleteItemSelect(int userInfoCompleteItemSelect) {
        this.userInfoCompleteItemSelect = userInfoCompleteItemSelect;
    }

    public int getUserInfoCompleteItemDatePicker() {
        if (userInfoCompleteItemDatePicker == 0) {
            return R.layout.authing_userinfo_complete_item_datepicker;
        }
        return userInfoCompleteItemDatePicker;
    }

    public void setUserInfoCompleteItemDatePicker(int userInfoCompleteItemDatePicker) {
        this.userInfoCompleteItemDatePicker = userInfoCompleteItemDatePicker;
    }

    public int getResetPasswordFirstLoginLayoutId() {
        if (resetPasswordFirstLoginLayoutId == 0) {
            resetPasswordFirstLoginLayoutId = R.layout.authing_reset_password_first_login;
        }
        return resetPasswordFirstLoginLayoutId;
    }

    public void setResetPasswordFirstLoginLayoutId(int resetPasswordFirstLoginLayoutId) {
        this.resetPasswordFirstLoginLayoutId = resetPasswordFirstLoginLayoutId;
    }

    public int getVerifyEmailSendSuccessLayoutId() {
        if (verifyEmailSendSuccessLayoutId == 0) {
            verifyEmailSendSuccessLayoutId = R.layout.authing_verify_emial_send_success;
        }
        return verifyEmailSendSuccessLayoutId;
    }

    public void setVerifyEmailSendSuccessLayoutId(int verifyEmailSendSuccessLayoutId) {
        this.verifyEmailSendSuccessLayoutId = verifyEmailSendSuccessLayoutId;
    }

    public int[] getSocialAccountBindLayoutIds() {
        if (socialBindAccountLayoutIds == null) {
            return new int[]{R.layout.authing_social_account_bind_before, R.layout.authing_social_account_bind};
        }
        return socialBindAccountLayoutIds;
    }

    public void setSocialAccountBindLayoutIds(int[] socialBindAccountLayoutIds) {
        this.socialBindAccountLayoutIds = socialBindAccountLayoutIds;
    }

    public int getSocialBindAccountCurrentStep() {
        return socialBindAccountCurrentStep;
    }

    public void setSocialBindAccountCurrentStep(int socialBindAccountCurrentStep) {
        this.socialBindAccountCurrentStep = socialBindAccountCurrentStep;
    }

    public int getPushLoginLayoutId() {
        if (pushLoginLayoutId == 0) {
            pushLoginLayoutId = R.layout.authing_push_login;
        }
        return pushLoginLayoutId;
    }

    public void setPushLoginLayoutId(int pushLoginLayoutId) {
        this.pushLoginLayoutId = pushLoginLayoutId;
    }

    public int getPushLoginSuccessLayoutId() {
        if (pushLoginSuccessLayoutId == 0) {
            pushLoginSuccessLayoutId = R.layout.authing_push_login_success;
        }
        return pushLoginSuccessLayoutId;
    }

    public void setPushLoginSuccessLayoutId(int pushLoginSuccessLayoutId) {
        this.pushLoginSuccessLayoutId = pushLoginSuccessLayoutId;
    }

    public int getBiometricAccountBindLayoutId() {
        if (biometricAccountBindLayoutId == 0) {
            biometricAccountBindLayoutId = R.layout.authing_biometric_account_bind;
        }
        return biometricAccountBindLayoutId;
    }

    public void setBiometricAccountBindLayoutId(int biometricAccountBindLayoutId) {
        this.biometricAccountBindLayoutId = biometricAccountBindLayoutId;
    }

    public int getBiometricAccountBindSuccessLayoutId() {
        if (biometricAccountBindSuccessLayoutId == 0) {
            biometricAccountBindSuccessLayoutId = R.layout.authing_biometric_account_bind_success;
        }
        return biometricAccountBindSuccessLayoutId;
    }

    public void setBiometricAccountBindSuccessLayoutId(int biometricAccountBindSuccessLayoutId) {
        this.biometricAccountBindSuccessLayoutId = biometricAccountBindSuccessLayoutId;
    }

    public Callback<UserInfo> getAuthCallback() {
        return authCallback;
    }

    public AuthFlow setAuthCallback(Callback<UserInfo> authCallback) {
        this.authCallback = authCallback;
        return this;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isSkipConsent() {
        return skipConsent;
    }

    public void setSkipConsent(boolean skipConsent) {
        this.skipConsent = skipConsent;
    }

    public boolean isSyncData() {
        return syncData;
    }

    public void setSyncData(boolean syncData) {
        this.syncData = syncData;
    }

    public AuthFlowUIConfig getUiConfig() {
        return uiConfig;
    }

    private void setUiConfig(AuthFlowUIConfig uiConfig) {
        AuthFlow.uiConfig = uiConfig;
    }
}
