/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.config;

import cn.authing.bean.AuthingProperties;
import cn.authing.core.mgmt.ManagementClient;
import cn.authing.interceptor.AuthingHandlerInterceptor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={AuthingProperties.class})
public class AuthingAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    AuthingProperties authingProperties;
    @Autowired
    ObjectMapper objectMapper;

    @Bean
    public ManagementClient managementClient() {
        return new ManagementClient(this.authingProperties.getUserPool().getUserPoolId(), this.authingProperties.getUserPool().getSecret());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AuthingHandlerInterceptor(this.managementClient(), this.authingProperties, this.objectMapper)).addPathPatterns(new String[]{"/**"}).excludePathPatterns(this.authingProperties.getExcludePaths());
    }
}

