/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.interceptor;

import cn.authing.bean.AuthingProperties;
import cn.authing.bean.JwtPayload;
import cn.authing.core.mgmt.ManagementClient;
import cn.authing.core.types.AuthorizedResource;
import cn.authing.core.types.ListAuthorizedResourcesOptions;
import cn.authing.core.types.PaginatedAuthorizedResources;
import cn.authing.core.types.PolicyAssignmentTargetType;
import cn.authing.core.types.ResourceType;
import cn.authing.exception.AuthingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class AuthingHandlerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthingHandlerInterceptor.class);
    private final ManagementClient managementClient;
    private final AuthingProperties authingProperties;
    private final ObjectMapper objectMapper;

    public AuthingHandlerInterceptor(ManagementClient managementClient, AuthingProperties authingProperties, ObjectMapper objectMapper) {
        this.managementClient = managementClient;
        this.authingProperties = authingProperties;
        this.objectMapper = objectMapper;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String header = request.getHeader("Authorization");
        String token = header.replace("Bearer ", "").replace("bearer ", "");
        if (ObjectUtils.isEmpty((Object)token)) {
            throw new AuthingException("\u672a\u767b\u5f55", HttpStatus.FORBIDDEN);
        }
        try {
            String s = token.split(".")[1];
            byte[] decode = Base64.getDecoder().decode(s);
            JwtPayload jwtPayload = (JwtPayload)this.objectMapper.readValue(decode, JwtPayload.class);
            String userId = jwtPayload.getSub();
            ListAuthorizedResourcesOptions resourcesOptions = new ListAuthorizedResourcesOptions(ResourceType.API);
            PaginatedAuthorizedResources resources = (PaginatedAuthorizedResources)this.managementClient.acl().listAuthorizedResources(PolicyAssignmentTargetType.USER, userId, this.authingProperties.getApp().getAppId(), resourcesOptions).execute();
            List identifiers = resources.getList().stream().map(AuthorizedResource::getApiIdentifier).collect(Collectors.toList());
            String uri = request.getRequestURI();
            for (String r : identifiers) {
                if (!uri.contains(r)) continue;
                log.info("\u9274\u6743\u901a\u8fc7");
                return true;
            }
            log.info("\u65e0\u6743\u9650");
            return false;
        }
        catch (Exception e) {
            throw new AuthingException("token \u9519\u8bef", HttpStatus.FORBIDDEN);
        }
    }
}

