/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.sdk.java.client;

import cn.authing.sdk.java.client.BaseClient;
import cn.authing.sdk.java.dto.AuthorizedResourcePaginatedRespDto;
import cn.authing.sdk.java.dto.BindEmailDto;
import cn.authing.sdk.java.dto.BindPhoneDto;
import cn.authing.sdk.java.dto.ChangeQRCodeStatusDto;
import cn.authing.sdk.java.dto.CheckQRCodeStatusRespDto;
import cn.authing.sdk.java.dto.CheckQrcodeStatusDto;
import cn.authing.sdk.java.dto.CommonResponseDto;
import cn.authing.sdk.java.dto.DecryptWechatMiniProgramDataDto;
import cn.authing.sdk.java.dto.DecryptWechatMiniProgramDataRespDto;
import cn.authing.sdk.java.dto.DeleteAccounDto;
import cn.authing.sdk.java.dto.EnrollFactorDto;
import cn.authing.sdk.java.dto.EnrollFactorRespDto;
import cn.authing.sdk.java.dto.ExchangeTokenSetWithQRcodeTicketDto;
import cn.authing.sdk.java.dto.GeneQRCodeRespDto;
import cn.authing.sdk.java.dto.GenerateBindExtIdpLinkRespDto;
import cn.authing.sdk.java.dto.GenerateLinkExtidpUrlDto;
import cn.authing.sdk.java.dto.GenerateQrcodeDto;
import cn.authing.sdk.java.dto.GetAccessTokenByClientCredentialsDto;
import cn.authing.sdk.java.dto.GetAccessTokenByClientCredentialsRespDto;
import cn.authing.sdk.java.dto.GetAccessibleAppsRespDto;
import cn.authing.sdk.java.dto.GetAlipayAuthInfoRespDto;
import cn.authing.sdk.java.dto.GetAlipayAuthinfoDto;
import cn.authing.sdk.java.dto.GetCountryListRespDto;
import cn.authing.sdk.java.dto.GetExtIdpsRespDto;
import cn.authing.sdk.java.dto.GetFactorDto;
import cn.authing.sdk.java.dto.GetFactorRespDto;
import cn.authing.sdk.java.dto.GetIdentitiesRespDto;
import cn.authing.sdk.java.dto.GetLoggedInAppsRespDto;
import cn.authing.sdk.java.dto.GetLoginHistoryRespDto;
import cn.authing.sdk.java.dto.GetMyAuthorizedResourcesDto;
import cn.authing.sdk.java.dto.GetMyDepartmentListDto;
import cn.authing.sdk.java.dto.GetMyLoginHistoryDto;
import cn.authing.sdk.java.dto.GetMyRoleListDto;
import cn.authing.sdk.java.dto.GetNewAccessTokenByRefreshTokenDto;
import cn.authing.sdk.java.dto.GetNewAccessTokenByRefreshTokenRespDto;
import cn.authing.sdk.java.dto.GetProfileDto;
import cn.authing.sdk.java.dto.GetSecurityInfoRespDto;
import cn.authing.sdk.java.dto.GetTenantListRespDto;
import cn.authing.sdk.java.dto.GetWechatAccessTokenDto;
import cn.authing.sdk.java.dto.GetWechatAccessTokenRespDto;
import cn.authing.sdk.java.dto.GetWechatMiniProgramPhoneDto;
import cn.authing.sdk.java.dto.GetWechatMiniProgramPhoneRespDto;
import cn.authing.sdk.java.dto.GroupListRespDto;
import cn.authing.sdk.java.dto.IntrospectTokenDto;
import cn.authing.sdk.java.dto.IntrospectTokenWithClientSecretPostRespDto;
import cn.authing.sdk.java.dto.IsSuccessRespDto;
import cn.authing.sdk.java.dto.ListEnrolledFactorsRespDto;
import cn.authing.sdk.java.dto.ListFactorsToEnrollRespDto;
import cn.authing.sdk.java.dto.LoginTokenRespDto;
import cn.authing.sdk.java.dto.PasswordResetVerifyResp;
import cn.authing.sdk.java.dto.PreCheckCodeDto;
import cn.authing.sdk.java.dto.PreCheckCodeRespDto;
import cn.authing.sdk.java.dto.ResetFactorDto;
import cn.authing.sdk.java.dto.ResetFactorRespDto;
import cn.authing.sdk.java.dto.ResetPasswordDto;
import cn.authing.sdk.java.dto.RevokeTokenDto;
import cn.authing.sdk.java.dto.RoleListRespDto;
import cn.authing.sdk.java.dto.SendEmailDto;
import cn.authing.sdk.java.dto.SendEmailRespDto;
import cn.authing.sdk.java.dto.SendEnrollFactorRequestDto;
import cn.authing.sdk.java.dto.SendEnrollFactorRequestRespDto;
import cn.authing.sdk.java.dto.SendSMSDto;
import cn.authing.sdk.java.dto.SendSMSRespDto;
import cn.authing.sdk.java.dto.SignInByAdPayloadDto;
import cn.authing.sdk.java.dto.SignInByLdapPayloadDto;
import cn.authing.sdk.java.dto.SignInByPassCodePayloadDto;
import cn.authing.sdk.java.dto.SignInByPasswordPayloadDto;
import cn.authing.sdk.java.dto.SignInOptionsDto;
import cn.authing.sdk.java.dto.SignUpByPassCodeDto;
import cn.authing.sdk.java.dto.SignUpByPasswordDto;
import cn.authing.sdk.java.dto.SignUpDto;
import cn.authing.sdk.java.dto.SignUpOptionsDto;
import cn.authing.sdk.java.dto.SignUpProfileDto;
import cn.authing.sdk.java.dto.SigninByCredentialsDto;
import cn.authing.sdk.java.dto.SigninByMobileDto;
import cn.authing.sdk.java.dto.SystemInfoResp;
import cn.authing.sdk.java.dto.TokenEndPointParams;
import cn.authing.sdk.java.dto.UnbindEmailDto;
import cn.authing.sdk.java.dto.UnbindPhoneDto;
import cn.authing.sdk.java.dto.UnlinkExtIdpDto;
import cn.authing.sdk.java.dto.UpdateEmailDto;
import cn.authing.sdk.java.dto.UpdatePasswordDto;
import cn.authing.sdk.java.dto.UpdatePhoneDto;
import cn.authing.sdk.java.dto.UpdateUserProfileDto;
import cn.authing.sdk.java.dto.UserDepartmentPaginatedRespDto;
import cn.authing.sdk.java.dto.UserSingleRespDto;
import cn.authing.sdk.java.dto.ValidateTokenRespDto;
import cn.authing.sdk.java.dto.VerifyDeleteAccountRequestDto;
import cn.authing.sdk.java.dto.VerifyDeleteAccountRequestRespDto;
import cn.authing.sdk.java.dto.VerifyResetPasswordRequestDto;
import cn.authing.sdk.java.dto.VerifyUpdateEmailRequestDto;
import cn.authing.sdk.java.dto.VerifyUpdateEmailRequestRespDto;
import cn.authing.sdk.java.dto.VerifyUpdatePhoneRequestDto;
import cn.authing.sdk.java.dto.VerifyUpdatePhoneRequestRespDto;
import cn.authing.sdk.java.dto.authentication.AccessToken;
import cn.authing.sdk.java.dto.authentication.BuildLogoutUrlParams;
import cn.authing.sdk.java.dto.authentication.CodeChallengeDigestParam;
import cn.authing.sdk.java.dto.authentication.CodeToTokenParams;
import cn.authing.sdk.java.dto.authentication.IDToken;
import cn.authing.sdk.java.dto.authentication.IOidcParams;
import cn.authing.sdk.java.dto.authentication.OIDCTokenResponse;
import cn.authing.sdk.java.dto.authentication.UserInfo;
import cn.authing.sdk.java.dto.authentication.ValidateTicketV1Response;
import cn.authing.sdk.java.dto.authentication.ValidateTokenParams;
import cn.authing.sdk.java.enums.AuthMethodEnum;
import cn.authing.sdk.java.enums.ProtocolEnum;
import cn.authing.sdk.java.model.AuthenticationClientOptions;
import cn.authing.sdk.java.model.AuthingRequestConfig;
import cn.authing.sdk.java.model.ClientCredentialInput;
import cn.authing.sdk.java.util.CommonUtils;
import cn.authing.sdk.java.util.HttpUtils;
import cn.hutool.core.codec.Base64Encoder;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Optional;

public class AuthenticationClient
extends BaseClient {
    private final AuthenticationClientOptions options;
    private final String appId;
    private JWKSet jwks;

    public AuthenticationClient(AuthenticationClientOptions options) throws IOException, ParseException {
        super(options);
        this.options = options;
        this.appId = options.getAppId();
        if (!options.getScope().contains("openid")) {
            throw new IllegalArgumentException("scope \u4e2d\u5fc5\u987b\u5305\u542b openid");
        }
    }

    public void setAccessToken(String accessToken) {
        this.options.setAccessToken(accessToken);
    }

    private JWKSet fetchJwks() throws IOException, ParseException {
        JWKSet jwks;
        if (this.jwks != null) {
            return this.jwks;
        }
        this.jwks = jwks = JWKSet.load((URL)new URL(this.options.getAppHost() + "/oidc/.well-known/jwks.json"));
        return jwks;
    }

    private IDToken parseIDToken(String token) throws Exception {
        JWSObject jwsObject = JWSObject.parse((String)token);
        if (jwsObject.getHeader().getAlgorithm() == JWSAlgorithm.HS256) {
            MACVerifier jwsVerifier = new MACVerifier(this.options.getAppSecret());
            if (!jwsObject.verify((JWSVerifier)jwsVerifier)) {
                throw new Exception("token \u7b7e\u540d\u4e0d\u5408\u6cd5");
            }
        } else {
            RSAKey rsaKey = ((JWK)this.fetchJwks().getKeys().get(0)).toRSAKey();
            RSASSAVerifier verifier = new RSASSAVerifier(rsaKey);
            if (!jwsObject.verify((JWSVerifier)verifier)) {
                throw new Exception("\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
        }
        String payload = jwsObject.getPayload().toString();
        return AuthenticationClient.deserialize(payload, IDToken.class);
    }

    private AccessToken introspectAccessTokenOffline(String token) throws Exception {
        RSAKey rsaKey;
        RSASSAVerifier verifier;
        JWSObject jwsObject = JWSObject.parse((String)token);
        if (!jwsObject.verify((JWSVerifier)(verifier = new RSASSAVerifier(rsaKey = ((JWK)this.fetchJwks().getKeys().get(0)).toRSAKey())))) {
            throw new Exception("\u6821\u9a8c\u4e0d\u901a\u8fc7");
        }
        String payload = jwsObject.getPayload().toString();
        return AuthenticationClient.deserialize(payload, AccessToken.class);
    }

    public OIDCTokenResponse getAccessTokenByCode(String code) throws Exception {
        if ((StrUtil.isBlank((CharSequence)this.options.getAppId()) || StrUtil.isBlank((CharSequence)this.options.getAppSecret())) && this.options.getTokenEndPointAuthMethod() != AuthMethodEnum.NONE.getValue()) {
            throw new Exception("\u8bf7\u5728\u521d\u59cb\u5316 AuthenticationClient \u65f6\u4f20\u5165 appId \u548c secret \u53c2\u6570");
        }
        String url = "";
        url = this.options.getProtocol() == ProtocolEnum.OAUTH.getValue() ? url + "/oauth/token" : url + "/oidc/token";
        CodeToTokenParams tokenParam = new CodeToTokenParams();
        tokenParam.setRedirectUri(this.options.getRedirectUri());
        tokenParam.setCode(code);
        tokenParam.setGrantType("authorization_code");
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl(url);
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            tokenParam.setClientId(this.options.getAppId());
            tokenParam.setClientSecret(this.options.getAppSecret());
        } else if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_BASIC.getValue()) {
            String basic64Str = "Basic " + Base64.getEncoder().encodeToString((this.options.getAppId() + ":" + this.options.getAppSecret()).getBytes());
            headerMap.put("Authorization", basic64Str);
        } else {
            tokenParam.setClientId(this.options.getAppId());
        }
        config.setHeaders(headerMap);
        config.setBody(tokenParam);
        String response = this.request(config);
        OIDCTokenResponse deserializeOIDCResponse = AuthenticationClient.deserialize(response, OIDCTokenResponse.class);
        return deserializeOIDCResponse;
    }

    public ValidateTicketV1Response validateTicketV1(String ticket, String service) {
        String url = this.options.getAppHost() + "/cas-idp/" + this.options.getAppId() + "/validate";
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ticket", ticket);
        paramsMap.put("service", service);
        url = HttpUtils.buildUrlWithQueryParams(url, paramsMap);
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl(url);
        String response = this.request(config);
        ValidateTicketV1Response validateTicketV1Response = AuthenticationClient.deserialize(response, ValidateTicketV1Response.class);
        System.out.println("ValidateTicketV1Response:" + validateTicketV1Response.toString());
        return validateTicketV1Response;
    }

    public String validateTicketV2(String ticket, String service, String format) throws Exception {
        if (format != "XML" && format != "JSON") {
            throw new Exception("format \u53c2\u6570\u53ef\u9009\u503c\u4e3a XML\u3001JSON\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165");
        }
        String url = this.options.getAppHost() + "/cas-idp/" + this.options.getAppId() + "/serviceValidate";
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ticket", ticket);
        paramsMap.put("service", service);
        paramsMap.put("format", format);
        url = HttpUtils.buildUrlWithQueryParams(url, paramsMap);
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl(url);
        String response = this.request(config);
        return response;
    }

    public String getCodeChallengeDigest(CodeChallengeDigestParam options) throws Exception {
        String codeChallenge = options.getCodeChallenge();
        String method = options.getMethod();
        if (StrUtil.isBlank((CharSequence)codeChallenge)) {
            throw new Exception("\u8bf7\u63d0\u4f9b options.codeChallenge\uff0c\u503c\u4e3a\u4e00\u4e2a\u957f\u5ea6\u5927\u4e8e\u7b49\u4e8e 43 \u7684\u5b57\u7b26\u4e32");
        }
        if (method == "S256" || method == "") {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(codeChallenge.getBytes("UTF-8"));
            byte[] encode = Base64.getEncoder().encode(messageDigest.digest());
            return new String(encode, Charset.forName("UTF-8")).replace("+", "-").replace("/", "_").replace("=", "");
        }
        if (method == "plain") {
            return codeChallenge;
        }
        throw new Exception("\u4e0d\u652f\u6301\u7684 options.method\uff0c\u53ef\u9009\u503c\u4e3a S256\u3001plain");
    }

    public String buildLogoutUrl(BuildLogoutUrlParams params) throws Exception {
        if (this.options.getProtocol() == ProtocolEnum.OAUTH.getValue()) {
            return this.buildCasLogoutUrl(params);
        }
        if (this.options.getProtocol() == ProtocolEnum.OIDC.getValue()) {
            return this.buildOidcLogoutUrl(params);
        }
        return this.buildEasyLogoutUrl(params);
    }

    private String buildCasLogoutUrl(BuildLogoutUrlParams params) {
        String url = "";
        url = StrUtil.isNotBlank((CharSequence)params.getPostLogoutRedirectUri()) ? this.options.getAppHost() + "/cas-idp/logout?url=" + params.getPostLogoutRedirectUri() : this.options.getAppHost() + "/cas-idp/logout";
        return url;
    }

    private String buildOidcLogoutUrl(BuildLogoutUrlParams params) throws Exception {
        if (params.getPostLogoutRedirectUri() != null && params.getIdTokenHint() == null || params.getPostLogoutRedirectUri() == null && params.getIdTokenHint() != null) {
            throw new Exception("\u5fc5\u987b\u540c\u65f6\u4f20\u5165 idToken \u548c redirectUri \u53c2\u6570\uff0c\u6216\u8005\u540c\u65f6\u90fd\u4e0d\u4f20\u5165");
        }
        String url = "";
        url = StrUtil.isNotBlank((CharSequence)params.getPostLogoutRedirectUri()) ? this.options.getAppHost() + "/oidc/session/end?id_token_hint=" + params.getIdTokenHint() + "&post_logout_redirect_uri=" + params.getPostLogoutRedirectUri() : this.options.getAppHost() + "/oidc/session/end";
        return url;
    }

    private String buildEasyLogoutUrl(BuildLogoutUrlParams params) throws Exception {
        String url = "";
        url = StrUtil.isNotBlank((CharSequence)params.getPostLogoutRedirectUri()) ? this.options.getAppHost() + "/login/profile/logout?redirect_uri=" + params.getPostLogoutRedirectUri() : this.options.getAppHost() + "/login/profile/logout";
        return url;
    }

    public GetAccessTokenByClientCredentialsRespDto getAccessTokenByClientCredentials(String scope, ClientCredentialInput options) throws Exception {
        if (StrUtil.isEmpty((CharSequence)scope)) {
            throw new InvalidParameterException("\u8bf7\u4f20\u5165 scope \u53c2\u6570\uff0c\u8bf7\u770b\u6587\u6863\uff1ahttps://docs.authing.cn/v2/guides/authorization/m2m-authz.html");
        }
        if (options == null) {
            throw new InvalidParameterException("\u8bf7\u5728\u8c03\u7528\u672c\u65b9\u6cd5\u65f6\u4f20\u5165 { accessKey: string, accessSecret: string }\uff0c\u8bf7\u770b\u6587\u6863\uff1ahttps://docs.authing.cn/v2/guides/authorization/m2m-authz.html");
        }
        GetAccessTokenByClientCredentialsDto reqDto = new GetAccessTokenByClientCredentialsDto();
        reqDto.setScope(scope);
        reqDto.setClientId(options.getAccessKey());
        reqDto.setClientSecret(options.getAccessSecret());
        reqDto.setGrantType(TokenEndPointParams.Grant_type.CLIENT_CREDENTIALS.getValue());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/oidc/token");
        config.setBody(reqDto);
        config.setMethod("UrlencodedPOST");
        config.setHeaders(headers);
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetAccessTokenByClientCredentialsRespDto.class);
    }

    public UserInfo getUserInfoByAccessToken(String accessToken) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OAUTH.getValue().equals(this.options.getProtocol())) {
            config.setMethod("POST");
            config.setBody(new Object());
        } else {
            config.setMethod("GET");
        }
        config.setUrl("/oidc/me/?access_token=" + accessToken);
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, UserInfo.class);
    }

    public String buildAuthorizeUrl(IOidcParams params) {
        if (this.options.getAppId() == null) {
            throw new InvalidParameterException("\u8bf7\u5728\u521d\u59cb\u5316 AuthenticationClient \u65f6\u4f20\u5165 appId");
        }
        if (!ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            throw new InvalidParameterException("\u521d\u59cb\u5316 AuthenticationClient \u4f20\u5165\u7684 protocol \u5e94\u4e3a ProtocolEnum.OIDC \u4e0d\u5e94\u8be5\u4e3a $protocol");
        }
        if (StrUtil.isEmpty((CharSequence)this.options.getRedirectUri()) && StrUtil.isEmpty((CharSequence)params.getRedirectUri())) {
            throw new InvalidParameterException("redirectUri \u4e0d\u5e94\u8be5\u4e3a\u7a7a \u89e3\u51b3\u65b9\u6cd5\uff1a\u8bf7\u5728 AuthenticationClient \u521d\u59cb\u5316\u65f6\u4f20\u5165 redirectUri\uff0c\u6216\u8005\u8c03\u7528 buildAuthorizeUrl \u65f6\u4f20\u5165 redirectUri");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("client_id", Optional.ofNullable(params.getAppId()).orElse(this.options.getAppId()));
        map.put("scope", Optional.ofNullable(params.getScope()).orElse("openid profile email phone address"));
        map.put("state", Optional.ofNullable(params.getState()).orElse(CommonUtils.createRandomString(12)));
        map.put("nonce", Optional.ofNullable(params.getNonce()).orElse(CommonUtils.createRandomString(12)));
        map.put("response_mode", Optional.ofNullable(params.getResponseMode()).orElse(null));
        map.put("response_type", Optional.ofNullable(params.getResponseType()).orElse("code"));
        map.put("redirect_uri", Optional.ofNullable(params.getRedirectUri()).orElse(this.options.getRedirectUri()));
        map.put("prompt", params.getScope() != null && params.getScope().contains("offline_access") ? "consent" : null);
        return HttpUtils.buildUrlWithQueryParams(this.options.getAppHost() + "/oidc/auth", map);
    }

    public GetNewAccessTokenByRefreshTokenRespDto getNewAccessTokenByRefreshToken(String refreshToken) {
        this.verificationProtocol();
        String tokenEndPointAuthMethod = this.options.getTokenEndPointAuthMethod();
        if (AuthMethodEnum.CLIENT_SECRET_POST.getValue().equals(tokenEndPointAuthMethod)) {
            return this.getNewAccessTokenByRefreshTokenWithClientSecretPost(refreshToken);
        }
        if (AuthMethodEnum.CLIENT_SECRET_BASIC.getValue().equals(tokenEndPointAuthMethod)) {
            return this.getNewAccessTokenByRefreshTokenWithClientSecretBasic(refreshToken);
        }
        return this.getNewAccessTokenByRefreshTokenWithNone(refreshToken);
    }

    private void verificationProtocol() {
        if (!ProtocolEnum.OAUTH.getValue().equals(this.options.getProtocol()) && !ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            throw new InvalidParameterException("\u521d\u59cb\u5316 AuthenticationClient \u65f6\u4f20\u5165\u7684 protocol \u53c2\u6570\u5fc5\u987b\u4e3a ProtocolEnum.OAUTH \u6216 ProtocolEnum.OIDC\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (StrUtil.isEmpty((CharSequence)this.options.getAppSecret()) && !AuthMethodEnum.NONE.getValue().equals(this.options.getTokenEndPointAuthMethod())) {
            throw new InvalidParameterException("\u8bf7\u5728\u521d\u59cb\u5316 AuthenticationClient \u65f6\u4f20\u5165 appId \u548c secret \u53c2\u6570");
        }
    }

    private GetNewAccessTokenByRefreshTokenRespDto getNewAccessTokenByRefreshTokenWithClientSecretPost(String refreshToken) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            config.setUrl("/oidc/token");
        } else {
            config.setUrl("/oauth/token");
        }
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        config.setHeaders(headers);
        GetNewAccessTokenByRefreshTokenDto reqDto = new GetNewAccessTokenByRefreshTokenDto();
        reqDto.setClientId(this.options.getAppId());
        reqDto.setClientSecret(this.options.getAppSecret());
        reqDto.setGrantType(TokenEndPointParams.Grant_type.REFRESH_TOKEN.getValue());
        reqDto.setRefreshToken(refreshToken);
        config.setBody(reqDto);
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetNewAccessTokenByRefreshTokenRespDto.class);
    }

    private GetNewAccessTokenByRefreshTokenRespDto getNewAccessTokenByRefreshTokenWithClientSecretBasic(String refreshToken) {
        String basic64Str = "Basic " + Base64Encoder.encode((byte[])(this.options.getAppId() + ":" + this.options.getAppSecret()).getBytes());
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            config.setUrl("/oidc/token");
        } else {
            config.setUrl("/oauth/token");
        }
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        headers.put(Header.AUTHORIZATION.getValue(), basic64Str);
        config.setHeaders(headers);
        GetNewAccessTokenByRefreshTokenDto reqDto = new GetNewAccessTokenByRefreshTokenDto();
        reqDto.setGrantType(TokenEndPointParams.Grant_type.REFRESH_TOKEN.getValue());
        reqDto.setRefreshToken(refreshToken);
        config.setBody(reqDto);
        String resqonse = this.request(config);
        return AuthenticationClient.deserialize(resqonse, GetNewAccessTokenByRefreshTokenRespDto.class);
    }

    private GetNewAccessTokenByRefreshTokenRespDto getNewAccessTokenByRefreshTokenWithNone(String refreshToken) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            config.setUrl("/oidc/token");
        } else {
            config.setUrl("/oauth/token");
        }
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        config.setHeaders(headers);
        GetNewAccessTokenByRefreshTokenDto reqDto = new GetNewAccessTokenByRefreshTokenDto();
        reqDto.setClientId(this.options.getAppId());
        reqDto.setGrantType(TokenEndPointParams.Grant_type.REFRESH_TOKEN.getValue());
        reqDto.setRefreshToken(refreshToken);
        config.setBody(reqDto);
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetNewAccessTokenByRefreshTokenRespDto.class);
    }

    public IntrospectTokenWithClientSecretPostRespDto introspectToken(String token) {
        this.verificationProtocol();
        String introspectionEndPointAuthMethod = this.options.getIntrospectionEndPointAuthMethod();
        if (AuthMethodEnum.CLIENT_SECRET_POST.getValue().equals(introspectionEndPointAuthMethod)) {
            return this.introspectTokenWithClientSecretPost(token);
        }
        if (AuthMethodEnum.CLIENT_SECRET_BASIC.getValue().equals(introspectionEndPointAuthMethod)) {
            return this.introspectTokenWithClientSecretBasic(token);
        }
        return this.introspectTokenWithNone(token);
    }

    private IntrospectTokenWithClientSecretPostRespDto introspectTokenWithClientSecretPost(String token) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            config.setUrl("/oidc/token/introspection");
        } else {
            config.setUrl("/oauth/token/introspection");
        }
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        config.setHeaders(headers);
        IntrospectTokenDto reqDto = new IntrospectTokenDto();
        reqDto.setClientId(this.options.getAppId());
        reqDto.setClientSecret(this.options.getAppSecret());
        reqDto.setToken(token);
        config.setBody(reqDto);
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, IntrospectTokenWithClientSecretPostRespDto.class);
    }

    private IntrospectTokenWithClientSecretPostRespDto introspectTokenWithClientSecretBasic(String token) {
        String basic64Str = "Basic " + Base64Encoder.encode((byte[])(this.options.getAppId() + ":" + this.options.getAppSecret()).getBytes());
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            config.setUrl("/oidc/token/introspection");
        } else {
            config.setUrl("/oauth/token/introspection");
        }
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        headers.put(Header.AUTHORIZATION.getValue(), basic64Str);
        config.setHeaders(headers);
        IntrospectTokenDto reqDto = new IntrospectTokenDto();
        reqDto.setToken(token);
        config.setBody(reqDto);
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, IntrospectTokenWithClientSecretPostRespDto.class);
    }

    private IntrospectTokenWithClientSecretPostRespDto introspectTokenWithNone(String token) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            config.setUrl("/oidc/token/introspection");
        } else {
            config.setUrl("/oauth/token/introspection");
        }
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        config.setHeaders(headers);
        IntrospectTokenDto reqDto = new IntrospectTokenDto();
        reqDto.setClientId(this.options.getAppId());
        reqDto.setToken(token);
        config.setBody(reqDto);
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, IntrospectTokenWithClientSecretPostRespDto.class);
    }

    public ValidateTokenRespDto validateToken(ValidateTokenParams params) {
        String idToken = params.getIdToken();
        String accessToken = params.getAccessToken();
        if (idToken == null && accessToken == null) {
            throw new InvalidParameterException("\u8bf7\u5728\u4f20\u5165\u7684\u53c2\u6570\u5bf9\u8c61\u4e2d\u5305\u542b accessToken \u6216 idToken \u5b57\u6bb5");
        }
        if (accessToken != null && idToken != null) {
            throw new InvalidParameterException("accessToken \u548c idToken \u53ea\u80fd\u4f20\u5165\u4e00\u4e2a\uff0c\u4e0d\u80fd\u540c\u65f6\u4f20\u5165");
        }
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (accessToken != null) {
            config.setUrl("/api/v2/oidc/validate_token?access_token=" + accessToken);
        } else {
            config.setUrl("/api/v2/oidc/validate_token?id_token=" + idToken);
        }
        config.setMethod("GET");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        config.setHeaders(headers);
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, ValidateTokenRespDto.class);
    }

    public Boolean revokeToken(String token) {
        this.verificationProtocol();
        String revocationEndPointAuthMethod = this.options.getRevocationEndPointAuthMethod();
        if (AuthMethodEnum.CLIENT_SECRET_POST.getValue().equals(revocationEndPointAuthMethod)) {
            return this.revokeTokenWithClientSecretPost(token);
        }
        if (AuthMethodEnum.CLIENT_SECRET_BASIC.getValue().equals(revocationEndPointAuthMethod)) {
            return this.revokeTokenWithClientSecretBasic(token);
        }
        return this.revokeTokenWithNone(token);
    }

    private Boolean revokeTokenWithClientSecretPost(String token) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            config.setUrl("/oidc/token/revocation");
        } else {
            config.setUrl("/oauth/token/revocation");
        }
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        config.setHeaders(headers);
        RevokeTokenDto reqDto = new RevokeTokenDto();
        reqDto.setClientId(this.options.getAppId());
        reqDto.setClientSecret(this.options.getAppSecret());
        reqDto.setToken(token);
        config.setBody(reqDto);
        this.request(config);
        return true;
    }

    private Boolean revokeTokenWithClientSecretBasic(String token) {
        if (ProtocolEnum.OAUTH.getValue().equals(this.options.getProtocol())) {
            throw new InvalidParameterException("OAuth 2.0 \u6682\u4e0d\u652f\u6301\u7528 client_secret_basic \u6a21\u5f0f\u8eab\u4efd\u9a8c\u8bc1\u64a4\u56de Token");
        }
        String basic64Str = "Basic " + Base64Encoder.encode((byte[])(this.options.getAppId() + ":" + this.options.getAppSecret()).getBytes());
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/oidc/token/revocation");
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        headers.put(Header.AUTHORIZATION.getValue(), basic64Str);
        config.setHeaders(headers);
        RevokeTokenDto reqDto = new RevokeTokenDto();
        reqDto.setToken(token);
        config.setBody(reqDto);
        this.request(config);
        return true;
    }

    private Boolean revokeTokenWithNone(String token) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        if (ProtocolEnum.OIDC.getValue().equals(this.options.getProtocol())) {
            config.setUrl("/oidc/token/revocation");
        } else {
            config.setUrl("/oauth/token/revocation");
        }
        config.setMethod("UrlencodedPOST");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(Header.CONTENT_TYPE.getValue(), "application/x-www-form-urlencoded");
        config.setHeaders(headers);
        RevokeTokenDto reqDto = new RevokeTokenDto();
        reqDto.setToken(token);
        reqDto.setClientId(this.options.getAppId());
        config.setBody(reqDto);
        this.request(config);
        return true;
    }

    public LoginTokenRespDto signInByUsernamePassword(String username, String password, SignInOptionsDto options) {
        SigninByCredentialsDto dto = new SigninByCredentialsDto();
        dto.setConnection(SigninByCredentialsDto.Connection.PASSWORD);
        SignInByPasswordPayloadDto payload = new SignInByPasswordPayloadDto();
        payload.setUsername(username);
        payload.setPassword(password);
        dto.setPasswordPayload(payload);
        dto.setOptions(options);
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            dto.setClientId(this.options.getAppId());
            dto.setClientSecret(this.options.getAppSecret());
        }
        return this.signInByCredentials(dto);
    }

    public LoginTokenRespDto signInByEmailPassword(String email, String password, SignInOptionsDto options) {
        SigninByCredentialsDto dto = new SigninByCredentialsDto();
        dto.setConnection(SigninByCredentialsDto.Connection.PASSWORD);
        SignInByPasswordPayloadDto payload = new SignInByPasswordPayloadDto();
        payload.setEmail(email);
        payload.setPassword(password);
        dto.setPasswordPayload(payload);
        dto.setOptions(options);
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            dto.setClientId(this.options.getAppId());
            dto.setClientSecret(this.options.getAppSecret());
        }
        return this.signInByCredentials(dto);
    }

    public LoginTokenRespDto signInByPhonePassword(String phone, String password, SignInOptionsDto options) {
        SigninByCredentialsDto dto = new SigninByCredentialsDto();
        dto.setConnection(SigninByCredentialsDto.Connection.PASSWORD);
        SignInByPasswordPayloadDto payload = new SignInByPasswordPayloadDto();
        payload.setPhone(phone);
        payload.setPassword(password);
        dto.setPasswordPayload(payload);
        dto.setOptions(options);
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            dto.setClientId(this.options.getAppId());
            dto.setClientSecret(this.options.getAppSecret());
        }
        return this.signInByCredentials(dto);
    }

    public LoginTokenRespDto signInByAccountPassword(String acconnt, String password, SignInOptionsDto options) {
        SigninByCredentialsDto dto = new SigninByCredentialsDto();
        dto.setConnection(SigninByCredentialsDto.Connection.PASSWORD);
        SignInByPasswordPayloadDto payload = new SignInByPasswordPayloadDto();
        payload.setAccount(acconnt);
        payload.setPassword(password);
        dto.setPasswordPayload(payload);
        dto.setOptions(options);
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            dto.setClientId(this.options.getAppId());
            dto.setClientSecret(this.options.getAppSecret());
        }
        return this.signInByCredentials(dto);
    }

    public LoginTokenRespDto signInByPhonePassCode(String phone, String passCode, String phoneCountryCode, SignInOptionsDto options) {
        SigninByCredentialsDto dto = new SigninByCredentialsDto();
        dto.setConnection(SigninByCredentialsDto.Connection.PASSCODE);
        SignInByPassCodePayloadDto payload = new SignInByPassCodePayloadDto();
        payload.setPhone(phone);
        payload.setPhoneCountryCode(phoneCountryCode);
        payload.setPassCode(passCode);
        dto.setPassCodePayload(payload);
        dto.setOptions(options);
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            dto.setClientId(this.options.getAppId());
            dto.setClientSecret(this.options.getAppSecret());
        }
        return this.signInByCredentials(dto);
    }

    public LoginTokenRespDto signInByEmailPassCode(String email, String passCode, SignInOptionsDto options) {
        SigninByCredentialsDto dto = new SigninByCredentialsDto();
        dto.setConnection(SigninByCredentialsDto.Connection.PASSCODE);
        SignInByPassCodePayloadDto payload = new SignInByPassCodePayloadDto();
        payload.setEmail(email);
        payload.setPassCode(passCode);
        dto.setPassCodePayload(payload);
        dto.setOptions(options);
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            dto.setClientId(this.options.getAppId());
            dto.setClientSecret(this.options.getAppSecret());
        }
        return this.signInByCredentials(dto);
    }

    public LoginTokenRespDto signInByLDAP(String sAMAccountName, String password, SignInOptionsDto options) {
        SigninByCredentialsDto dto = new SigninByCredentialsDto();
        dto.setConnection(SigninByCredentialsDto.Connection.LDAP);
        SignInByLdapPayloadDto payload = new SignInByLdapPayloadDto();
        payload.setPassword(password);
        payload.setSAMAccountName(sAMAccountName);
        dto.setLdapPayload(payload);
        dto.setOptions(options);
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            dto.setClientId(this.options.getAppId());
            dto.setClientSecret(this.options.getAppSecret());
        }
        return this.signInByCredentials(dto);
    }

    public LoginTokenRespDto signInByAD(String sAMAccountName, String password, SignInOptionsDto options) {
        SigninByCredentialsDto dto = new SigninByCredentialsDto();
        dto.setConnection(SigninByCredentialsDto.Connection.AD);
        SignInByAdPayloadDto payload = new SignInByAdPayloadDto();
        payload.setPassword(password);
        payload.setSAMAccountName(sAMAccountName);
        dto.setAdPayload(payload);
        dto.setOptions(options);
        if (this.options.getTokenEndPointAuthMethod() == AuthMethodEnum.CLIENT_SECRET_POST.getValue()) {
            dto.setClientId(this.options.getAppId());
            dto.setClientSecret(this.options.getAppSecret());
        }
        return this.signInByCredentials(dto);
    }

    public UserSingleRespDto signUpByUsernamePassword(String username, String password, SignUpProfileDto profile, SignUpOptionsDto options) {
        SignUpDto dto = new SignUpDto();
        dto.setConnection(SignUpDto.Connection.PASSWORD);
        SignUpByPasswordDto payload = new SignUpByPasswordDto();
        payload.setPassword(password);
        payload.setUsername(username);
        dto.setPasswordPayload(payload);
        dto.setProfile(profile);
        dto.setOptions(options);
        return this.signUp(dto);
    }

    public UserSingleRespDto signUpByEmailPassword(String email, String password, SignUpProfileDto profile, SignUpOptionsDto options) {
        SignUpDto dto = new SignUpDto();
        dto.setConnection(SignUpDto.Connection.PASSWORD);
        SignUpByPasswordDto payload = new SignUpByPasswordDto();
        payload.setPassword(password);
        payload.setEmail(email);
        dto.setPasswordPayload(payload);
        dto.setProfile(profile);
        dto.setOptions(options);
        return this.signUp(dto);
    }

    public UserSingleRespDto signUpByEmailPassCode(String email, String passCode, SignUpProfileDto profile, SignUpOptionsDto options) {
        SignUpDto dto = new SignUpDto();
        dto.setConnection(SignUpDto.Connection.PASSCODE);
        SignUpByPassCodeDto payload = new SignUpByPassCodeDto();
        payload.setPassCode(passCode);
        payload.setEmail(email);
        dto.setPassCodePayload(payload);
        dto.setProfile(profile);
        dto.setOptions(options);
        return this.signUp(dto);
    }

    public UserSingleRespDto signUpByPhonePassCode(String phone, String passCode, String phoneCountryCode, SignUpProfileDto profile, SignUpOptionsDto options) {
        SignUpDto dto = new SignUpDto();
        dto.setConnection(SignUpDto.Connection.PASSCODE);
        SignUpByPassCodeDto payload = new SignUpByPassCodeDto();
        payload.setPassCode(passCode);
        payload.setPhone(phone);
        payload.setPhoneCountryCode(phoneCountryCode);
        dto.setPassCodePayload(payload);
        dto.setProfile(profile);
        dto.setOptions(options);
        return this.signUp(dto);
    }

    public LoginTokenRespDto signInByCredentials(SigninByCredentialsDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/signin");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, LoginTokenRespDto.class);
    }

    public LoginTokenRespDto signInByMobile(SigninByMobileDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/signin-by-mobile");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, LoginTokenRespDto.class);
    }

    public GetAlipayAuthInfoRespDto getAlipayAuthInfo(GetAlipayAuthinfoDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-alipay-authinfo");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetAlipayAuthInfoRespDto.class);
    }

    public GeneQRCodeRespDto geneQrCode(GenerateQrcodeDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/gene-qrcode");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GeneQRCodeRespDto.class);
    }

    public CheckQRCodeStatusRespDto checkQrCodeStatus(CheckQrcodeStatusDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/check-qrcode-status");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CheckQRCodeStatusRespDto.class);
    }

    public LoginTokenRespDto exchangeTokenSetWithQrCodeTicket(ExchangeTokenSetWithQRcodeTicketDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/exchange-tokenset-with-qrcode-ticket");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, LoginTokenRespDto.class);
    }

    public CommonResponseDto changeQrCodeStatus(ChangeQRCodeStatusDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/change-qrcode-status");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public SendSMSRespDto sendSms(SendSMSDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/send-sms");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, SendSMSRespDto.class);
    }

    public SendEmailRespDto sendEmail(SendEmailDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/send-email");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, SendEmailRespDto.class);
    }

    public UserSingleRespDto getProfile(GetProfileDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-profile");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, UserSingleRespDto.class);
    }

    public UserSingleRespDto updateProfile(UpdateUserProfileDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/update-profile");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, UserSingleRespDto.class);
    }

    public CommonResponseDto bindEmail(BindEmailDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/bind-email");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public CommonResponseDto unbindEmail(UnbindEmailDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/unbind-email");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public CommonResponseDto bindPhone(BindPhoneDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/bind-phone");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public CommonResponseDto unbindPhone(UnbindPhoneDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/unbind-phone");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public GetSecurityInfoRespDto getSecurityLevel() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-security-info");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetSecurityInfoRespDto.class);
    }

    public CommonResponseDto updatePassword(UpdatePasswordDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/update-password");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public VerifyUpdateEmailRequestRespDto verifyUpdateEmailRequest(VerifyUpdateEmailRequestDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/verify-update-email-request");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, VerifyUpdateEmailRequestRespDto.class);
    }

    public CommonResponseDto updateEmail(UpdateEmailDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/update-email");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public VerifyUpdatePhoneRequestRespDto verifyUpdatePhoneRequest(VerifyUpdatePhoneRequestDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/verify-update-phone-request");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, VerifyUpdatePhoneRequestRespDto.class);
    }

    public CommonResponseDto updatePhone(UpdatePhoneDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/update-phone");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public PasswordResetVerifyResp verifyResetPasswordRequest(VerifyResetPasswordRequestDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/verify-reset-password-request");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, PasswordResetVerifyResp.class);
    }

    public IsSuccessRespDto resetPassword(ResetPasswordDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/reset-password");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, IsSuccessRespDto.class);
    }

    public VerifyDeleteAccountRequestRespDto verifyDeleteAccountRequest(VerifyDeleteAccountRequestDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/verify-delete-account-request");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, VerifyDeleteAccountRequestRespDto.class);
    }

    public IsSuccessRespDto deleteAccount(DeleteAccounDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/delete-account");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, IsSuccessRespDto.class);
    }

    public SystemInfoResp getSystemInfo() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/system");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, SystemInfoResp.class);
    }

    public GetCountryListRespDto getCountryList() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-country-list");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetCountryListRespDto.class);
    }

    public PreCheckCodeRespDto preCheckCode(PreCheckCodeDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/pre-check-code");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, PreCheckCodeRespDto.class);
    }

    public SendEnrollFactorRequestRespDto sendEnrollFactorRequest(SendEnrollFactorRequestDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/send-enroll-factor-request");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, SendEnrollFactorRequestRespDto.class);
    }

    public EnrollFactorRespDto enrollFactor(EnrollFactorDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/enroll-factor");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, EnrollFactorRespDto.class);
    }

    public ResetFactorRespDto resetFactor(ResetFactorDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/reset-factor");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, ResetFactorRespDto.class);
    }

    public ListEnrolledFactorsRespDto listEnrolledFactors() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/list-enrolled-factors");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, ListEnrolledFactorsRespDto.class);
    }

    public GetFactorRespDto getFactor(GetFactorDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-factor");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetFactorRespDto.class);
    }

    public ListFactorsToEnrollRespDto listFactorsToEnroll() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/list-factors-to-enroll");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, ListFactorsToEnrollRespDto.class);
    }

    public GenerateBindExtIdpLinkRespDto generateLinkExtIdpUrl(GenerateLinkExtidpUrlDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/generate-link-extidp-url");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GenerateBindExtIdpLinkRespDto.class);
    }

    public CommonResponseDto unlinkExtIdp(UnlinkExtIdpDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/unlink-extidp");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, CommonResponseDto.class);
    }

    public GetIdentitiesRespDto getIdentities() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-identities");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetIdentitiesRespDto.class);
    }

    public GetExtIdpsRespDto getApplicationEnabledExtIdps() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-application-enabled-extidps");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetExtIdpsRespDto.class);
    }

    public UserSingleRespDto signUp(SignUpDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/signup");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, UserSingleRespDto.class);
    }

    public DecryptWechatMiniProgramDataRespDto decryptWechatMiniProgramData(DecryptWechatMiniProgramDataDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/decrypt-wechat-miniprogram-data");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, DecryptWechatMiniProgramDataRespDto.class);
    }

    public GetWechatMiniProgramPhoneRespDto getWechatMiniprogramPhone(GetWechatMiniProgramPhoneDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-wechat-miniprogram-phone");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetWechatMiniProgramPhoneRespDto.class);
    }

    public GetWechatAccessTokenRespDto getWechatMpAccessToken(GetWechatAccessTokenDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-wechat-access-token");
        config.setBody(reqDto);
        config.setMethod("POST");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetWechatAccessTokenRespDto.class);
    }

    public GetLoginHistoryRespDto getLoginHistory(GetMyLoginHistoryDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-my-login-history");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetLoginHistoryRespDto.class);
    }

    public GetLoggedInAppsRespDto getLoggedInApps() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-my-logged-in-apps");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetLoggedInAppsRespDto.class);
    }

    public GetAccessibleAppsRespDto getAccessibleApps() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-my-accessible-apps");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetAccessibleAppsRespDto.class);
    }

    public GetTenantListRespDto getTenantList() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-my-tenant-list");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GetTenantListRespDto.class);
    }

    public RoleListRespDto getRoleList(GetMyRoleListDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-my-role-list");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, RoleListRespDto.class);
    }

    public GroupListRespDto getGroupList() {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-my-group-list");
        config.setBody(new Object());
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, GroupListRespDto.class);
    }

    public UserDepartmentPaginatedRespDto getDepartmentList(GetMyDepartmentListDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-my-department-list");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, UserDepartmentPaginatedRespDto.class);
    }

    public AuthorizedResourcePaginatedRespDto getAuthorizedResources(GetMyAuthorizedResourcesDto reqDto) {
        AuthingRequestConfig config = new AuthingRequestConfig();
        config.setUrl("/api/v3/get-my-authorized-resources");
        config.setBody(reqDto);
        config.setMethod("GET");
        String response = this.request(config);
        return AuthenticationClient.deserialize(response, AuthorizedResourcePaginatedRespDto.class);
    }
}

