/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.utils;

import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import java.util.List;

public class PointUtils {
    public static Dimension boundingBox(List<CoordinatePoint> points) {
        if (points == null || points.isEmpty()) {
            return null;
        }
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (CoordinatePoint point : points) {
            if (point.getX() < xMin) {
                xMin = point.getX();
            }
            if (point.getY() < yMin) {
                yMin = point.getY();
            }
            if (point.getX() > xMax) {
                xMax = point.getX();
            }
            if (point.getY() <= yMax) continue;
            yMax = point.getY();
        }
        int width = xMax - xMin;
        int height = yMax - yMin;
        CoordinatePoint point = CoordinatePoint.of(xMin, yMin);
        return Dimension.builder().width(width).height(height).point(point).build();
    }
}

