/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.utils;

import com.augrain.easy.canvas.exception.CanvasException;
import com.augrain.easy.canvas.model.Scale;
import com.augrain.easy.canvas.utils.RotateUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageUtils {
    private ImageUtils() {
    }

    public static BufferedImage loadUrl(String httpUrl) {
        try {
            return ImageIO.read(new URL(httpUrl));
        }
        catch (Exception e) {
            throw new CanvasException(e);
        }
    }

    public static BufferedImage loadFile(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (Exception e) {
            throw new CanvasException(e);
        }
    }

    public static BufferedImage rotate(BufferedImage image, int angle) {
        int[] bounds = RotateUtils.newBounds(image.getWidth(), image.getHeight(), angle);
        int newWidth = bounds[0];
        int newHeight = bounds[1];
        BufferedImage rotatedImage = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = rotatedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int x = (newWidth - image.getWidth()) / 2;
        int y = (newHeight - image.getHeight()) / 2;
        double radians = Math.toRadians(angle);
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.rotate(radians, (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        g.setTransform(transform);
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return rotatedImage;
    }

    public static BufferedImage roundedCorner(BufferedImage image, int cornerRadius) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage output = new BufferedImage(w, h, 2);
        Graphics2D g = output.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.fillRoundRect(0, 0, w, h, cornerRadius, cornerRadius);
        g.setComposite(AlphaComposite.SrcIn);
        g.drawImage(image, 0, 0, w, h, null);
        g.dispose();
        return output;
    }

    public static BufferedImage scale(BufferedImage image, Scale scale) {
        int width = 0;
        int height = 0;
        switch (scale.getZoomMode()) {
            case WIDTH: {
                width = scale.getWidth();
                height = image.getHeight() * width / image.getWidth();
                break;
            }
            case HEIGHT: {
                height = scale.getHeight();
                width = image.getWidth() * height / image.getHeight();
                break;
            }
            case WIDTH_HEIGHT: {
                height = scale.getWidth();
                width = scale.getHeight();
                break;
            }
            case RATIO: {
                height = (int)(scale.getRatio() * (double)image.getHeight());
                width = (int)(scale.getRatio() * (double)image.getWidth());
            }
        }
        Image scaledInstance = image.getScaledInstance(width, height, 4);
        BufferedImage scaleImg = new BufferedImage(width, height, image.getType());
        Graphics2D g = scaleImg.createGraphics();
        g.drawImage(scaledInstance, 0, 0, null);
        g.dispose();
        return scaleImg;
    }

    public static BufferedImage crop(BufferedImage image, String ratio) {
        int cropWidth;
        int cropHeight;
        int srcWidth = image.getWidth();
        int srcHeight = image.getHeight();
        String[] ratioParts = ratio.split(":");
        if (ratioParts.length != 2) {
            throw new CanvasException("\u6bd4\u4f8b\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u4e3a 'width:height'\uff0c\u4f8b\u5982 '1:1'");
        }
        double targetRatio = Double.parseDouble(ratioParts[0]) / Double.parseDouble(ratioParts[1]);
        if ((double)srcWidth / (double)srcHeight > targetRatio) {
            cropHeight = srcHeight;
            cropWidth = (int)((double)cropHeight * targetRatio);
        } else {
            cropWidth = srcWidth;
            cropHeight = (int)((double)cropWidth / targetRatio);
        }
        int x = (srcWidth - cropWidth) / 2;
        int y = (srcHeight - cropHeight) / 2;
        return image.getSubimage(x, y, cropWidth, cropHeight);
    }
}

