/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.text;

import com.augrain.easy.canvas.text.ITextSplitter;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextSplitterSimpleImpl
implements ITextSplitter {
    private static final Map<Character, Integer> charSizeMap = new HashMap<Character, Integer>();

    @Override
    public List<String> splitText(String text, int width, FontMetrics fontMetrics) {
        ArrayList<String> lines = new ArrayList<String>();
        int size = fontMetrics.getFont().getSize();
        char[] charArray = text.toCharArray();
        int currentSize = 0;
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < charArray.length; ++index) {
            int cSize = TextSplitterSimpleImpl.getCharSize(charArray[index], size, fontMetrics);
            if (currentSize + cSize > width) {
                lines.add(builder.toString());
                builder.setLength(0);
                builder.append(charArray[index]);
                currentSize = 1;
                continue;
            }
            currentSize += cSize;
            builder.append(charArray[index]);
        }
        if (builder.length() > 0) {
            lines.add(builder.toString());
        }
        return lines;
    }

    private static int getCharSize(char c, int defaultSize, FontMetrics fm) {
        if (TextSplitterSimpleImpl.isFullWidthChar(c)) {
            return defaultSize;
        }
        return charSizeMap.computeIfAbsent(Character.valueOf(c), k -> fm.charWidth(c));
    }

    private static boolean isFullWidthChar(char c) {
        return c >= '\u4e00' && c <= '\u9fff' || c >= '\u3040' && c <= '\u30ff' || c >= '\uff01' && c <= '\uff5e';
    }
}

