/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.model;

import java.awt.BasicStroke;
import java.util.function.Function;

public enum LineStyle {
    DASH(i -> {
        float[] dashPattern = new float[]{10.0f, 5.0f};
        return new BasicStroke(i.intValue(), 0, 0, 10.0f, dashPattern, 0.0f);
    }),
    DOT(i -> {
        float[] dotPattern = new float[]{2.0f, 5.0f};
        return new BasicStroke(i.intValue(), 1, 1, 10.0f, dotPattern, 0.0f);
    }),
    DASH_DOT(i -> {
        float[] dashDotPattern = new float[]{10.0f, 5.0f, 2.0f, 5.0f};
        return new BasicStroke(i.intValue(), 2, 2, 10.0f, dashDotPattern, 0.0f);
    });

    private final Function<Integer, BasicStroke> convert;

    private LineStyle(Function<Integer, BasicStroke> convert) {
        this.convert = convert;
    }

    public BasicStroke toStroke(int width) {
        return this.convert.apply(width);
    }
}

