/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.model;

import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import java.util.function.Function;

public enum GradientDirection {
    TOP_BOTTOM(d -> {
        int fromX = d.getPoint().getX() + d.getWidth() / 2;
        int fromY = d.getPoint().getY();
        int toX = fromX;
        int toY = d.getPoint().getY() + d.getHeight();
        return new CoordinatePoint[]{CoordinatePoint.of(fromX, fromY), CoordinatePoint.of(toX, toY)};
    }),
    LEFT_RIGHT(d -> {
        int fromX = d.getPoint().getX();
        int fromY = d.getPoint().getY() + d.getHeight() / 2;
        int toX = d.getPoint().getX() + d.getWidth();
        int toY = fromY;
        return new CoordinatePoint[]{CoordinatePoint.of(fromX, fromY), CoordinatePoint.of(toX, toY)};
    }),
    TOP_LEFT_RIGHT_BOTTOM(d -> {
        int fromX = d.getPoint().getX();
        int fromY = d.getPoint().getY();
        int toX = d.getPoint().getX() + d.getWidth();
        int toY = d.getPoint().getY() + d.getHeight();
        return new CoordinatePoint[]{CoordinatePoint.of(fromX, fromY), CoordinatePoint.of(toX, toY)};
    }),
    TOP_RIGHT_LEFT_BOTTOM(d -> {
        int fromX = d.getPoint().getX() + d.getWidth();
        int fromY = d.getPoint().getY();
        int toX = d.getPoint().getX();
        int toY = d.getPoint().getY() + d.getHeight();
        return new CoordinatePoint[]{CoordinatePoint.of(fromX, fromY), CoordinatePoint.of(toX, toY)};
    });

    private final Function<Dimension, CoordinatePoint[]> directionCalculator;

    private GradientDirection(Function<Dimension, CoordinatePoint[]> directionCalculator) {
        this.directionCalculator = directionCalculator;
    }

    public CoordinatePoint[] calcStartEnd(Dimension dimension) {
        return this.directionCalculator.apply(dimension);
    }
}

