/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.model;

import com.augrain.easy.canvas.exception.CanvasException;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import com.augrain.easy.canvas.model.GradientDirection;
import com.augrain.easy.canvas.utils.HexUtils;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.util.Arrays;

public class Gradient {
    private final Color[] colors;
    private final GradientDirection direction;
    private float[] fractions;

    private Gradient(Color[] colors, GradientDirection direction) {
        if (colors.length < 2) {
            throw new CanvasException("colors.length < 2");
        }
        this.colors = colors;
        this.direction = direction;
    }

    public Gradient setFractions(float[] fractions) {
        if (fractions.length != this.colors.length) {
            throw new CanvasException("fractions.length != colors.length");
        }
        this.fractions = fractions;
        return this;
    }

    public static Gradient of(Color[] colors, GradientDirection direction) {
        return new Gradient(colors, direction);
    }

    public static Gradient of(String[] colors, GradientDirection direction) {
        return new Gradient(Gradient.transformColor(colors), direction);
    }

    private static Color[] transformColor(String[] colors) {
        return (Color[])Arrays.stream(colors).map(HexUtils::hexToColor).toArray(Color[]::new);
    }

    public Paint toGradient(Dimension dimension) {
        CoordinatePoint[] coordinatePoints = this.direction.calcStartEnd(dimension);
        CoordinatePoint start = coordinatePoints[0];
        CoordinatePoint end = coordinatePoints[1];
        return new LinearGradientPaint(new Point(start.getX(), start.getY()), new Point(end.getX(), end.getY()), this.getFractions(), this.colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    }

    private float[] getFractions() {
        if (this.fractions != null) {
            return this.fractions;
        }
        float[] fractions = new float[this.colors.length];
        float interval = 1.0f / (float)this.colors.length;
        for (int i = 0; i < fractions.length - 1; ++i) {
            fractions[i] = interval * (float)i;
        }
        fractions[fractions.length - 1] = 1.0f;
        return fractions;
    }
}

