/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.geometry;

import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Margin;
import com.augrain.easy.canvas.geometry.Position;

public enum Positions implements Position
{
    CENTER{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = (enclosingWidth - elementWidth) / 2;
            int y = (enclosingHeight - elementHeight) / 2;
            return CoordinatePoint.of(x, y);
        }
    }
    ,
    LEFT_CENTER{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = margin.getMarginLeft();
            int y = (enclosingHeight - elementHeight) / 2;
            return CoordinatePoint.of(x, y);
        }
    }
    ,
    RIGHT_CENTER{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = enclosingWidth - elementWidth - margin.getMarginRight();
            int y = (enclosingHeight - elementHeight) / 2;
            return CoordinatePoint.of(x, y);
        }
    }
    ,
    TOP_LEFT{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = margin.getMarginLeft();
            int y = margin.getMarginTop();
            return CoordinatePoint.of(x, y);
        }
    }
    ,
    TOP_CENTER{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = (enclosingWidth - elementWidth) / 2;
            int y = margin.getMarginTop();
            return CoordinatePoint.of(x, y);
        }
    }
    ,
    TOP_RIGHT{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = enclosingWidth - elementWidth - margin.getMarginRight();
            int y = margin.getMarginTop();
            return CoordinatePoint.of(x, y);
        }
    }
    ,
    LEFT_BOTTOM{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = margin.getMarginLeft();
            int y = enclosingHeight - elementHeight - margin.getMarginBottom();
            return CoordinatePoint.of(x, y);
        }
    }
    ,
    BOTTOM_CENTER{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = (enclosingWidth - elementWidth) / 2;
            int y = enclosingHeight - elementHeight - margin.getMarginBottom();
            return CoordinatePoint.of(x, y);
        }
    }
    ,
    RIGHT_BOTTOM{

        @Override
        public CoordinatePoint calculate(int enclosingWidth, int enclosingHeight, int elementWidth, int elementHeight, Margin margin) {
            int x = enclosingWidth - elementWidth - margin.getMarginRight();
            int y = enclosingHeight - elementHeight - margin.getMarginBottom();
            return CoordinatePoint.of(x, y);
        }
    };

}

