/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.geometry;

public class Margin {
    public static Margin DEFAULT = Margin.of(0);
    private int marginLeft = 0;
    private int marginRight = 0;
    private int marginTop = 0;
    private int marginBottom = 0;

    private Margin() {
    }

    private Margin(int marginLeft, int marginTop, int marginRight, int marginBottom) {
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
    }

    public Margin setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public Margin setMarginRight(int marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public Margin setMarginTop(int marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public Margin setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public static Margin of() {
        return Margin.of(0);
    }

    public static Margin of(int margin) {
        return new Margin(margin, margin, margin, margin);
    }

    public static Margin of(int marginLeftRight, int marginTopBottom) {
        return new Margin(marginLeftRight, marginTopBottom, marginLeftRight, marginTopBottom);
    }

    public static Margin of(int marginLeft, int marginTop, int marginRight, int marginBottom) {
        return new Margin(marginLeft, marginTop, marginRight, marginBottom);
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public String toString() {
        return "Margin(marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ")";
    }
}

