/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.geometry;

import com.augrain.easy.canvas.geometry.CoordinatePoint;

public class Dimension {
    private int width;
    private int height;
    private int rotateWidth;
    private int rotateHeight;
    private int xOffset;
    private int yOffset;
    private CoordinatePoint point;

    public int widthDiff() {
        if (this.rotateWidth != 0) {
            return this.rotateWidth - this.width;
        }
        return 0;
    }

    public int heightDiff() {
        if (this.rotateHeight != 0) {
            return this.rotateHeight - this.height;
        }
        return 0;
    }

    public static DimensionBuilder builder() {
        return new DimensionBuilder();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRotateWidth() {
        return this.rotateWidth;
    }

    public int getRotateHeight() {
        return this.rotateHeight;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public CoordinatePoint getPoint() {
        return this.point;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setRotateWidth(int rotateWidth) {
        this.rotateWidth = rotateWidth;
    }

    public void setRotateHeight(int rotateHeight) {
        this.rotateHeight = rotateHeight;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public void setPoint(CoordinatePoint point) {
        this.point = point;
    }

    public String toString() {
        return "Dimension(width=" + this.getWidth() + ", height=" + this.getHeight() + ", rotateWidth=" + this.getRotateWidth() + ", rotateHeight=" + this.getRotateHeight() + ", xOffset=" + this.getXOffset() + ", yOffset=" + this.getYOffset() + ", point=" + this.getPoint() + ")";
    }

    public Dimension(int width, int height, int rotateWidth, int rotateHeight, int xOffset, int yOffset, CoordinatePoint point) {
        this.width = width;
        this.height = height;
        this.rotateWidth = rotateWidth;
        this.rotateHeight = rotateHeight;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.point = point;
    }

    public Dimension() {
    }

    public static class DimensionBuilder {
        private int width;
        private int height;
        private int rotateWidth;
        private int rotateHeight;
        private int xOffset;
        private int yOffset;
        private CoordinatePoint point;

        DimensionBuilder() {
        }

        public DimensionBuilder width(int width) {
            this.width = width;
            return this;
        }

        public DimensionBuilder height(int height) {
            this.height = height;
            return this;
        }

        public DimensionBuilder rotateWidth(int rotateWidth) {
            this.rotateWidth = rotateWidth;
            return this;
        }

        public DimensionBuilder rotateHeight(int rotateHeight) {
            this.rotateHeight = rotateHeight;
            return this;
        }

        public DimensionBuilder xOffset(int xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public DimensionBuilder yOffset(int yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public DimensionBuilder point(CoordinatePoint point) {
            this.point = point;
            return this;
        }

        public Dimension build() {
            return new Dimension(this.width, this.height, this.rotateWidth, this.rotateHeight, this.xOffset, this.yOffset, this.point);
        }

        public String toString() {
            return "Dimension.DimensionBuilder(width=" + this.width + ", height=" + this.height + ", rotateWidth=" + this.rotateWidth + ", rotateHeight=" + this.rotateHeight + ", xOffset=" + this.xOffset + ", yOffset=" + this.yOffset + ", point=" + this.point + ")";
        }
    }
}

