/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.special;

import com.augrain.easy.canvas.element.AbstractDimensionElement;
import com.augrain.easy.canvas.element.IElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import java.awt.Color;
import java.awt.Graphics2D;

public class RegularPolygonElement
extends AbstractDimensionElement<RegularPolygonElement>
implements IElement {
    private final int edges;
    private Color color = Color.BLACK;

    public RegularPolygonElement(int radius, int edges) {
        this.width = radius * 2;
        this.height = radius * 2;
        this.edges = edges;
    }

    public RegularPolygonElement setColor(Color color) {
        this.color = color;
        return this;
    }

    @Override
    public CoordinatePoint doRender(Graphics2D g, Dimension dimension, int canvasWidth, int canvasHeight) {
        int i;
        int r = this.width / 2;
        int centerX = dimension.getPoint().getX() + r;
        int centerY = dimension.getPoint().getY() + r;
        double thetaOffset = Math.PI / (double)this.edges;
        CoordinatePoint[] points = new CoordinatePoint[this.edges + 1];
        for (i = 0; i < this.edges; ++i) {
            double xi = (double)centerX + (double)r * Math.cos(Math.PI * 2 * (double)i / (double)this.edges - thetaOffset);
            double yi = (double)centerY + (double)r * Math.sin(Math.PI * 2 * (double)i / (double)this.edges - thetaOffset);
            points[i] = CoordinatePoint.of((int)xi, (int)yi);
        }
        points[this.edges] = points[0];
        for (i = 0; i < this.edges; ++i) {
            g.drawLine(points[i].getX(), points[i].getY(), points[i + 1].getX(), points[i + 1].getY());
        }
        return dimension.getPoint();
    }

    @Override
    public void beforeRender(Graphics2D g) {
        super.beforeRender(g);
        g.setColor(this.color);
    }
}

