/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.special;

import com.augrain.easy.canvas.element.AbstractDimensionElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class FivePointedStarElement
extends AbstractDimensionElement {
    private int borderSize = 0;
    private Color color = Color.BLACK;

    public FivePointedStarElement(int radius) {
        this.width = radius * 2;
        this.height = radius * 2;
    }

    public FivePointedStarElement setColor(Color color) {
        this.color = color;
        return this;
    }

    public FivePointedStarElement setBorderSize(int borderSize) {
        this.borderSize = borderSize;
        return this;
    }

    @Override
    public CoordinatePoint doRender(Graphics2D g, Dimension dimension, int canvasWidth, int canvasHeight) {
        int centerX = dimension.getPoint().getX() + this.width / 2;
        int radius = this.width / 2;
        int[] point0 = new int[]{centerX, centerX - radius};
        int[] point1 = new int[]{centerX + (int)(Math.sin(1.2566370614359172) * (double)radius), centerX - (int)(Math.cos(1.2566370614359172) * (double)radius)};
        int[] point2 = new int[]{centerX + (int)(Math.sin(0.6283185307179586) * (double)radius), centerX + (int)(Math.cos(0.6283185307179586) * (double)radius)};
        int[] point3 = new int[]{centerX - (int)(Math.sin(0.6283185307179586) * (double)radius), centerX + (int)(Math.cos(0.6283185307179586) * (double)radius)};
        int[] point4 = new int[]{centerX - (int)(Math.sin(1.2566370614359172) * (double)radius), centerX - (int)(Math.cos(1.2566370614359172) * (double)radius)};
        int[] point5 = new int[]{centerX, centerX};
        if (this.borderSize > 0) {
            g.setStroke(new BasicStroke(this.borderSize, 1, 1));
            FivePointedStarElement.drawLine(g, point0, point1, point2, point3, point4, point5);
        } else {
            FivePointedStarElement.drawPolygon(g, point0, point1, point2, point3, point4, point5);
        }
        return dimension.getPoint();
    }

    private static void drawLine(Graphics2D g, int[] point0, int[] point1, int[] point2, int[] point3, int[] point4, int[] point5) {
        FivePointedStarElement.doDrawLine(g, point0, point2, point1, point4);
        FivePointedStarElement.doDrawLine(g, point1, point3, point2, point0);
        FivePointedStarElement.doDrawLine(g, point2, point4, point3, point1);
        FivePointedStarElement.doDrawLine(g, point3, point0, point4, point2);
        FivePointedStarElement.doDrawLine(g, point4, point1, point0, point3);
    }

    private static void doDrawLine(Graphics2D g, int[] p1, int[] p2, int[] q1, int[] q2) {
        int[] p = FivePointedStarElement.findLineIntersection(p1, p2, q1, q2);
        if (p == null) {
            return;
        }
        g.drawLine(p1[0], p1[1], p[0], p[1]);
        g.drawLine(q1[0], q1[1], p[0], p[1]);
    }

    private static int[] findLineIntersection(int[] p1, int[] p2, int[] q1, int[] q2) {
        double x1 = p1[0];
        double x2 = p2[0];
        double y3 = q1[1];
        double y4 = q2[1];
        double y1 = p1[1];
        double y2 = p2[1];
        double x3 = q1[0];
        double x4 = q2[0];
        double denominator = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (denominator == 0.0) {
            return null;
        }
        double px = ((x1 * y2 - y1 * x2) * (x3 - x4) - (x1 - x2) * (x3 * y4 - y3 * x4)) / denominator;
        double py = ((x1 * y2 - y1 * x2) * (y3 - y4) - (y1 - y2) * (x3 * y4 - y3 * x4)) / denominator;
        return new int[]{(int)px, (int)py};
    }

    private static void drawPolygon(Graphics2D g, int[] point0, int[] point1, int[] point2, int[] point3, int[] point4, int[] point5) {
        FivePointedStarElement.doDrawPolygon(g, point0, point2, point3, point5);
        FivePointedStarElement.doDrawPolygon(g, point1, point3, point5, point4);
        FivePointedStarElement.doDrawPolygon(g, point2, point4, point5, point0);
        FivePointedStarElement.doDrawPolygon(g, point3, point0, point5, point1);
        FivePointedStarElement.doDrawPolygon(g, point4, point2, point5, point1);
    }

    private static void doDrawPolygon(Graphics2D g, int[] point0, int[] point2, int[] point3, int[] point5) {
        Polygon polygon = new Polygon();
        polygon.addPoint(point0[0], point0[1]);
        polygon.addPoint(point2[0], point2[1]);
        polygon.addPoint(point5[0], point5[1]);
        polygon.addPoint(point3[0], point3[1]);
        g.fillPolygon(polygon);
    }

    @Override
    public void beforeRender(Graphics2D g) {
        g.setColor(this.color);
    }
}

