/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.basic;

import com.augrain.easy.canvas.element.AbstractRepeatableElement;
import com.augrain.easy.canvas.element.IElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import com.augrain.easy.canvas.model.BaseLine;
import com.augrain.easy.canvas.text.TextSplitterSimpleImpl;
import com.augrain.easy.canvas.utils.RotateUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TextElement
extends AbstractRepeatableElement<TextElement>
implements IElement {
    private final String text;
    private Color fontColor = Color.BLACK;
    private String fontName = "\u5fae\u8f6f\u96c5\u9ed1";
    private int fontStyle = 0;
    private int fontSize = 12;
    private Font font;
    private BaseLine baseLine = BaseLine.CENTER;
    private Integer lineHeight;
    private boolean autoWordWrap = false;
    private int maxTextWidth;
    private boolean strikeThrough = false;
    private List<String> splitText;

    public TextElement(String text) {
        this.text = text;
    }

    public static TextElement of(String text) {
        return new TextElement(text);
    }

    public TextElement setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public TextElement setFontName(String fontName) {
        this.fontName = fontName;
        return this;
    }

    public TextElement setFontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public TextElement setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
        return this;
    }

    public TextElement setFont(String fontName, int fontStyle, int fontSize) {
        this.fontName = fontName;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize;
        return this;
    }

    public TextElement setFont(Font font) {
        this.font = font;
        return this;
    }

    public TextElement setBaseLine(BaseLine baseLine) {
        this.baseLine = baseLine;
        return this;
    }

    public TextElement setLineHeight(Integer lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public TextElement setAutoWrapText(int maxTextWidth) {
        this.autoWordWrap = true;
        this.maxTextWidth = maxTextWidth;
        return this;
    }

    public TextElement setStrikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
        return this;
    }

    private Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        return new Font(this.fontName, this.fontStyle, this.fontSize);
    }

    @Override
    public Dimension calculateDimension(Graphics2D g, int canvasWidth, int canvasHeight) {
        int width;
        FontMetrics fm = g.getFontMetrics();
        int height = Optional.ofNullable(this.lineHeight).orElse(fm.getHeight());
        if (this.autoWordWrap) {
            TextSplitterSimpleImpl splitter = new TextSplitterSimpleImpl();
            this.splitText = splitter.splitText(this.text, this.maxTextWidth, fm);
            width = this.maxTextWidth;
        } else {
            Rectangle2D textBounds = fm.getStringBounds(this.text, g);
            width = (int)textBounds.getWidth();
            this.splitText = Collections.singletonList(this.text);
        }
        CoordinatePoint point = CoordinatePoint.ORIGIN_COORDINATE;
        if (this.position != null) {
            point = this.position.calculate(canvasWidth, canvasHeight, width, height);
        }
        Dimension.DimensionBuilder builder = Dimension.builder().width(width).height(height).yOffset(this.baseLine.getOffset(fm, height)).point(point);
        if (this.getRotate() != 0) {
            int[] newBounds = RotateUtils.newBounds(width, height, this.getRotate());
            builder.rotateWidth(newBounds[0]).rotateHeight(newBounds[1]);
        }
        return builder.build();
    }

    @Override
    public CoordinatePoint doRender(Graphics2D g, Dimension dimension, int canvasWidth, int canvasHeight) {
        super.gradient(g, dimension);
        CoordinatePoint point = dimension.getPoint();
        for (int i = 0; i < this.splitText.size(); ++i) {
            int startX = point.getX() + dimension.getXOffset();
            int startY = point.getY() + dimension.getYOffset() + i * dimension.getHeight();
            if (this.getRotate() != 0) {
                double rotateX = (double)point.getX() + (double)dimension.getWidth() / 2.0;
                double rotateY = (double)point.getY() + (double)dimension.getHeight() / 2.0 + (double)(i * dimension.getHeight());
                AffineTransform rotateTransform = AffineTransform.getRotateInstance(Math.toRadians(this.rotate), rotateX, rotateY);
                AffineTransform savedTransform = g.getTransform();
                g.setTransform(rotateTransform);
                this.doDrawText(g, this.splitText.get(i), startX, startY);
                g.setTransform(savedTransform);
                continue;
            }
            this.doDrawText(g, this.splitText.get(i), startX, startY);
        }
        return dimension.getPoint();
    }

    private void doDrawText(Graphics2D g, String text, int startX, int startY) {
        if (this.strikeThrough) {
            AttributedString as = new AttributedString(text);
            as.addAttribute(TextAttribute.FONT, g.getFont());
            as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 0, text.length());
            g.drawString(as.getIterator(), startX, startY);
        } else {
            g.drawString(text, startX, startY);
        }
    }

    @Override
    public void beforeRender(Graphics2D g) {
        super.beforeRender(g);
        g.setFont(this.getFont());
        g.setColor(this.getFontColor());
    }

    public String getText() {
        return this.text;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public BaseLine getBaseLine() {
        return this.baseLine;
    }

    public Integer getLineHeight() {
        return this.lineHeight;
    }

    public boolean isAutoWordWrap() {
        return this.autoWordWrap;
    }

    public int getMaxTextWidth() {
        return this.maxTextWidth;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    public List<String> getSplitText() {
        return this.splitText;
    }
}

