/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.basic;

import com.augrain.easy.canvas.element.AbstractDimensionElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;

public class RectangleElement
extends AbstractDimensionElement<RectangleElement> {
    private double borderSize = 0.0;
    private double arcWidth = 0.0;
    private double arcHeight = 0.0;
    private Color color = Color.BLACK;

    public RectangleElement(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public RectangleElement setArc(int arc) {
        this.arcWidth = arc;
        this.arcHeight = arc;
        return this;
    }

    public RectangleElement setArc(int arcWidth, int arcHeight) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        return this;
    }

    public RectangleElement setColor(Color color) {
        this.color = color;
        return this;
    }

    public RectangleElement setBorderSize(int borderSize) {
        this.borderSize = borderSize;
        return this;
    }

    @Override
    public CoordinatePoint doRender(Graphics2D g, Dimension dimension, int canvasWidth, int canvasHeight) {
        super.gradient(g, dimension);
        CoordinatePoint point = dimension.getPoint();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(point.getX(), point.getY(), this.width, this.height, this.arcWidth, this.arcHeight);
        if (this.borderSize > 0.0 && this.borderSize < (double)Math.max(this.width, this.height)) {
            RoundRectangle2D.Double inner = new RoundRectangle2D.Double((double)point.getX() + this.borderSize, (double)point.getY() + this.borderSize, (double)this.width - 2.0 * this.borderSize, (double)this.height - 2.0 * this.borderSize, Math.max(0.0, this.arcWidth - this.borderSize), Math.max(0.0, this.arcHeight - this.borderSize));
            Area outerArea = new Area(rect);
            outerArea.subtract(new Area(inner));
            g.fill(outerArea);
        } else {
            g.fill(rect);
        }
        return dimension.getPoint();
    }

    @Override
    public void beforeRender(Graphics2D g) {
        g.setColor(this.color);
    }

    public double getBorderSize() {
        return this.borderSize;
    }

    public double getArcWidth() {
        return this.arcWidth;
    }

    public double getArcHeight() {
        return this.arcHeight;
    }

    public Color getColor() {
        return this.color;
    }
}

