/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.basic;

import com.augrain.easy.canvas.element.AbstractElement;
import com.augrain.easy.canvas.element.IElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import com.augrain.easy.canvas.model.LineStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;

public class LineElement
extends AbstractElement<LineElement>
implements IElement {
    private final CoordinatePoint start;
    private final CoordinatePoint end;
    private int borderSize = 1;
    private Color color = Color.BLACK;
    private LineStyle lineStyle;

    public LineElement(CoordinatePoint start, CoordinatePoint end) {
        this.start = start;
        this.end = end;
    }

    public LineElement(CoordinatePoint start, CoordinatePoint end, int borderSize) {
        this.start = start;
        this.end = end;
        this.borderSize = borderSize;
    }

    public LineElement setColor(Color color) {
        this.color = color;
        return this;
    }

    public LineElement setLineStyle(LineStyle lineStyle) {
        this.lineStyle = lineStyle;
        return this;
    }

    public LineElement setBorderSize(int borderSize) {
        this.borderSize = borderSize;
        return this;
    }

    @Override
    public Dimension calculateDimension(Graphics2D g, int canvasWidth, int canvasHeight) {
        return null;
    }

    @Override
    public CoordinatePoint doRender(Graphics2D g, Dimension dimension, int canvasWidth, int canvasHeight) {
        g.drawLine(this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY());
        return this.start;
    }

    @Override
    public void beforeRender(Graphics2D g) {
        g.setColor(this.color);
        if (this.lineStyle != null) {
            g.setStroke(this.lineStyle.toStroke(this.borderSize));
        } else {
            g.setStroke(new BasicStroke(this.borderSize));
        }
    }
}

