/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.basic;

import com.augrain.easy.canvas.element.AbstractDimensionElement;
import com.augrain.easy.canvas.element.IElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import com.augrain.easy.canvas.model.Scale;
import com.augrain.easy.canvas.utils.ImageUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;

public class ImageElement
extends AbstractDimensionElement<ImageElement>
implements IElement {
    private BufferedImage image;

    public ImageElement(BufferedImage image) {
        this.image = image;
        this.handleDimension();
    }

    public ImageElement(String httpUrl) {
        this.image = ImageUtils.loadUrl(httpUrl);
        this.handleDimension();
    }

    public ImageElement(File file) {
        this.image = ImageUtils.loadFile(file);
        this.handleDimension();
    }

    private void handleDimension() {
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
    }

    public ImageElement scale(Scale scale) {
        this.image = ImageUtils.scale(this.image, scale);
        this.handleDimension();
        return this;
    }

    public ImageElement rotate(int angel) {
        this.image = ImageUtils.rotate(this.image, angel);
        this.handleDimension();
        return this;
    }

    public ImageElement crop(String ratio) {
        this.image = ImageUtils.crop(this.image, ratio);
        this.handleDimension();
        return this;
    }

    public ImageElement roundCorner(int roundCorner) {
        this.image = ImageUtils.roundedCorner(this.image, roundCorner);
        this.handleDimension();
        return this;
    }

    @Override
    public CoordinatePoint doRender(Graphics2D g, Dimension dimension, int canvasWidth, int canvasHeight) {
        CoordinatePoint point = dimension.getPoint();
        g.drawImage(this.getImage(), point.getX(), point.getY(), dimension.getWidth(), dimension.getHeight(), null);
        return point;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

