/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.basic;

import com.augrain.easy.canvas.element.AbstractDimensionElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

public class CircleElement
extends AbstractDimensionElement<CircleElement> {
    private double borderSize = 0.0;
    private Color color = Color.BLACK;

    public CircleElement(int radius) {
        this.width = radius * 2;
        this.height = radius * 2;
    }

    public CircleElement(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public CircleElement setBorderSize(int borderSize) {
        this.borderSize = borderSize;
        return this;
    }

    public CircleElement setColor(Color color) {
        this.color = color;
        return this;
    }

    @Override
    public CoordinatePoint doRender(Graphics2D g, Dimension dimension, int canvasWidth, int canvasHeight) {
        super.gradient(g, dimension);
        CoordinatePoint point = dimension.getPoint();
        if (this.borderSize > 0.0 && this.borderSize < (double)Math.max(this.width, this.height)) {
            Ellipse2D.Double outer = new Ellipse2D.Double(point.getX(), point.getY(), this.width, this.height);
            Ellipse2D.Double inner = new Ellipse2D.Double((double)point.getX() + this.borderSize, (double)point.getY() + this.borderSize, (double)this.width - 2.0 * this.borderSize, (double)this.height - 2.0 * this.borderSize);
            Area ring = new Area(outer);
            ring.subtract(new Area(inner));
            g.fill(ring);
        } else {
            g.fillOval(point.getX(), point.getY(), this.width, this.height);
        }
        return dimension.getPoint();
    }

    @Override
    public void beforeRender(Graphics2D g) {
        g.setColor(this.color);
    }
}

