/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.advance;

import com.augrain.easy.canvas.element.AbstractRepeatableElement;
import com.augrain.easy.canvas.element.IElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import com.augrain.easy.canvas.geometry.Margin;
import com.augrain.easy.canvas.geometry.Positions;
import com.augrain.easy.canvas.geometry.RelativePosition;
import java.awt.Graphics2D;

public class RepeatElement
implements IElement {
    private final AbstractRepeatableElement basicElement;
    private int xPadding = 0;
    private int yPadding = 0;
    private Layout layout;

    public RepeatElement(AbstractRepeatableElement basicElement) {
        this.basicElement = basicElement;
    }

    public RepeatElement setXPadding(int xPadding) {
        this.xPadding = xPadding;
        return this;
    }

    public RepeatElement setYPadding(int yPadding) {
        this.yPadding = yPadding;
        return this;
    }

    public RepeatElement setPadding(int xPadding, int yPadding) {
        this.xPadding = xPadding;
        this.yPadding = yPadding;
        return this;
    }

    public RepeatElement setLayout(int rows, int cols) {
        this.layout = new Layout(rows, cols, null);
        return this;
    }

    public RepeatElement setLayout(int rows, int cols, Margin margin) {
        this.layout = new Layout(rows, cols, margin);
        return this;
    }

    @Override
    public CoordinatePoint render(Graphics2D g, int canvasWidth, int canvasHeight) {
        this.basicElement.beforeRender(g);
        Dimension dimension = this.basicElement.calculateDimension(g, canvasWidth, canvasHeight);
        int elementWidth = Math.max(dimension.getRotateWidth(), dimension.getWidth());
        int elementHeight = Math.max(dimension.getRotateHeight(), dimension.getHeight());
        return this.doRepeat(g, canvasWidth, canvasHeight, elementWidth, elementHeight, dimension);
    }

    private CoordinatePoint doRepeat(Graphics2D g, int canvasWidth, int canvasHeight, int elementWidth, int elementHeight, Dimension dimension) {
        RepeatConfig result = this.getRepeatConfig(canvasWidth, canvasHeight, elementWidth, elementHeight, dimension);
        for (int j = 0; j < result.cols; ++j) {
            for (int i = 0; i < result.rows; ++i) {
                int x = i * (elementWidth + result.xPadding) + result.xOffset;
                int y = j * (elementHeight + result.yPadding) + result.yOffset;
                Margin elementMargin = Margin.of().setMarginLeft(x).setMarginTop(y);
                this.basicElement.setPosition(RelativePosition.of(Positions.TOP_LEFT, elementMargin));
                CoordinatePoint coordinatePoint = this.basicElement.reCalculatePosition(canvasWidth, canvasHeight, dimension);
                dimension.setPoint(coordinatePoint);
                this.basicElement.doRender(g, dimension, canvasWidth, canvasHeight);
            }
        }
        return CoordinatePoint.ORIGIN_COORDINATE;
    }

    private RepeatConfig getRepeatConfig(int canvasWidth, int canvasHeight, int elementWidth, int elementHeight, Dimension dimension) {
        if (this.layout != null) {
            int yOffset;
            int xOffset;
            int yInterval;
            int xInterval;
            Margin margin = this.layout.getMargin();
            if (margin != null) {
                int visualWidth = canvasWidth - margin.getMarginLeft() - margin.getMarginRight();
                int visualHeight = canvasHeight - margin.getMarginTop() - margin.getMarginBottom();
                xInterval = (visualWidth - this.layout.getRows() * elementWidth) / (this.layout.getRows() - 1);
                yInterval = (visualHeight - this.layout.getCols() * elementHeight) / (this.layout.getCols() - 1);
                xOffset = dimension.widthDiff() / 2 + margin.getMarginLeft();
                yOffset = Math.abs(dimension.heightDiff()) / 2 + margin.getMarginTop();
            } else {
                xInterval = (canvasWidth - this.layout.getRows() * elementWidth) / (this.layout.getRows() + 1);
                yInterval = (canvasHeight - this.layout.getCols() * elementHeight) / (this.layout.getCols() + 1);
                xOffset = dimension.widthDiff() / 2 + xInterval;
                yOffset = Math.abs(dimension.heightDiff()) / 2 + yInterval;
            }
            int rows = this.layout.getRows();
            int cols = this.layout.getCols();
            return new RepeatConfig(xInterval, yInterval, xOffset, yOffset, rows, cols);
        }
        int xOffset = dimension.widthDiff() / 2;
        int yOffset = Math.abs(dimension.heightDiff()) / 2;
        int rows = this.getRowNumber(elementWidth, canvasWidth);
        int cols = this.getColumnsNumber(elementHeight, canvasHeight);
        return new RepeatConfig(this.xPadding, this.yPadding, xOffset, yOffset, rows, cols);
    }

    private int getRowNumber(int elementWidth, int canvasWidth) {
        int rows = (this.xPadding + canvasWidth) / (elementWidth + this.xPadding);
        int left = (this.xPadding + canvasWidth) % (elementWidth + this.xPadding);
        if (left == 0) {
            return rows;
        }
        return rows + 1;
    }

    private int getColumnsNumber(int elementHeight, int canvasHeight) {
        int cols = (this.yPadding + canvasHeight) / (elementHeight + this.yPadding);
        int left = (this.yPadding + canvasHeight) % (elementHeight + this.yPadding);
        if (left == 0) {
            return cols;
        }
        return cols + 1;
    }

    private static class Layout {
        private int rows;
        private int cols;
        private Margin margin;

        public int getRows() {
            return this.rows;
        }

        public int getCols() {
            return this.cols;
        }

        public Margin getMargin() {
            return this.margin;
        }

        public Layout(int rows, int cols, Margin margin) {
            this.rows = rows;
            this.cols = cols;
            this.margin = margin;
        }
    }

    private static class RepeatConfig {
        public final int xPadding;
        public final int yPadding;
        public final int xOffset;
        public final int yOffset;
        public final int rows;
        public final int cols;

        public RepeatConfig(int xPadding, int yPadding, int xOffset, int yOffset, int rows, int cols) {
            this.xPadding = xPadding;
            this.yPadding = yPadding;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.rows = rows;
            this.cols = cols;
        }
    }
}

