/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element.advance;

import com.augrain.easy.canvas.element.AbstractElement;
import com.augrain.easy.canvas.element.AbstractRepeatableElement;
import com.augrain.easy.canvas.element.IElement;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import com.augrain.easy.canvas.geometry.Position;
import com.augrain.easy.canvas.geometry.RelativePosition;
import com.augrain.easy.canvas.model.RelativeDirection;
import com.augrain.easy.canvas.utils.PointUtils;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComposeElement
extends AbstractRepeatableElement<ComposeElement>
implements IElement {
    private final AbstractElement basicElement;
    private final List<ElementWrapper> elementWrapper = new ArrayList<ElementWrapper>();
    private final Map<AbstractElement, Dimension> dimensionMap = new HashMap<AbstractElement, Dimension>();
    private final Map<AbstractElement, PointOffset> pointOffsetMap = new HashMap<AbstractElement, PointOffset>();

    public ComposeElement(AbstractElement basicElement) {
        this.basicElement = basicElement;
    }

    public static ComposeElement of(AbstractElement basicElement) {
        return new ComposeElement(basicElement);
    }

    public ComposeElement bottom(AbstractElement element) {
        this.add(element, RelativeDirection.BOTTOM);
        return this;
    }

    public ComposeElement top(AbstractElement element) {
        this.add(element, RelativeDirection.TOP);
        return this;
    }

    public ComposeElement left(AbstractElement element) {
        this.add(element, RelativeDirection.LEFT);
        return this;
    }

    public ComposeElement right(AbstractElement element) {
        this.add(element, RelativeDirection.RIGHT);
        return this;
    }

    public ComposeElement in(AbstractElement element) {
        this.add(element, RelativeDirection.IN);
        return this;
    }

    public ComposeElement add(AbstractElement element, RelativeDirection direction) {
        this.add(element, direction, true);
        return this;
    }

    public ComposeElement add(AbstractElement element, RelativeDirection direction, boolean strict) {
        this.elementWrapper.add(new ElementWrapper(element, direction, strict, false));
        return this;
    }

    @Override
    public ComposeElement follow(AbstractElement element, RelativeDirection direction, boolean strict) {
        this.elementWrapper.add(new ElementWrapper(element, direction, strict, true));
        return this;
    }

    @Override
    public Dimension calculateDimension(Graphics2D g, int canvasWidth, int canvasHeight) {
        Dimension basicDimension = this.basicElement.calculateDimension(g, canvasWidth, canvasHeight);
        this.dimensionMap.put(this.basicElement, basicDimension);
        Map<RelativeDirection, List<ElementWrapper>> elementGroup = this.elementWrapper.stream().collect(Collectors.groupingBy(ElementWrapper::getDirection));
        elementGroup.forEach((direction, elementWrapperList) -> {
            block10: {
                block13: {
                    block12: {
                        block11: {
                            block9: {
                                if (direction != RelativeDirection.BOTTOM) break block9;
                                Dimension last = null;
                                for (ElementWrapper wrapper : elementWrapperList) {
                                    wrapper.getElement().beforeRender(g);
                                    Dimension dimension = this.doCalRelativeBottom(g, canvasWidth, canvasHeight, wrapper, basicDimension);
                                    if (last != null && wrapper.isFollow()) {
                                        dimension.getPoint().setY(dimension.getPoint().getY() + last.getHeight());
                                    }
                                    last = dimension;
                                    this.dimensionMap.put(wrapper.getElement(), dimension);
                                }
                                break block10;
                            }
                            if (direction != RelativeDirection.TOP) break block11;
                            Dimension last = null;
                            for (ElementWrapper wrapper : elementWrapperList) {
                                wrapper.getElement().beforeRender(g);
                                Dimension dimension = this.doCalRelativeTop(g, canvasWidth, wrapper, basicDimension);
                                if (last != null && wrapper.isFollow()) {
                                    dimension.getPoint().setY(dimension.getPoint().getY() - last.getHeight());
                                }
                                last = dimension;
                                this.dimensionMap.put(wrapper.getElement(), dimension);
                            }
                            break block10;
                        }
                        if (direction != RelativeDirection.LEFT) break block12;
                        Dimension last = null;
                        for (ElementWrapper wrapper : elementWrapperList) {
                            wrapper.getElement().beforeRender(g);
                            Dimension dimension = this.doCalRelativeLeft(g, canvasHeight, wrapper, basicDimension);
                            if (last != null && wrapper.isFollow()) {
                                dimension.getPoint().setX(dimension.getPoint().getX() - last.getWidth());
                            }
                            last = dimension;
                            this.dimensionMap.put(wrapper.getElement(), dimension);
                        }
                        break block10;
                    }
                    if (direction != RelativeDirection.RIGHT) break block13;
                    Dimension last = null;
                    for (ElementWrapper wrapper : elementWrapperList) {
                        wrapper.getElement().beforeRender(g);
                        Dimension dimension = this.doCalRelativeRight(g, canvasWidth, canvasHeight, wrapper, basicDimension);
                        if (last != null && wrapper.isFollow()) {
                            dimension.getPoint().setX(dimension.getPoint().getX() + last.getWidth());
                        }
                        last = dimension;
                        this.dimensionMap.put(wrapper.getElement(), dimension);
                    }
                    break block10;
                }
                if (direction != RelativeDirection.IN) break block10;
                for (ElementWrapper wrapper : elementWrapperList) {
                    wrapper.getElement().beforeRender(g);
                    Dimension dimension = this.doCalRelativeIn(g, wrapper, basicDimension);
                    this.dimensionMap.put(wrapper.getElement(), dimension);
                }
            }
        });
        return this.calculateBoundingBox(this.dimensionMap);
    }

    private Dimension doCalRelativeIn(Graphics2D g, ElementWrapper elementWrapper, Dimension basicDimension) {
        AbstractElement element = elementWrapper.getElement();
        Dimension dimension = element.calculateDimension(g, basicDimension.getWidth(), basicDimension.getHeight());
        Position position = element.getPosition();
        if (position instanceof RelativePosition) {
            CoordinatePoint point = dimension.getPoint();
            point.setX(point.getX() + basicDimension.getPoint().getX());
            point.setY(point.getY() + basicDimension.getPoint().getY());
        }
        return dimension;
    }

    private Dimension doCalRelativeRight(Graphics2D g, int canvasWidth, int canvasHeight, ElementWrapper elementWrapper, Dimension basicDimension) {
        AbstractElement element = elementWrapper.getElement();
        int relativeHeight = elementWrapper.isStrict() ? basicDimension.getHeight() : canvasHeight;
        int relativeWidth = canvasWidth - basicDimension.getWidth() - basicDimension.getPoint().getX();
        Dimension dimension = element.calculateDimension(g, relativeWidth, relativeHeight);
        Position position = element.getPosition();
        if (position instanceof RelativePosition) {
            CoordinatePoint point = dimension.getPoint();
            if (elementWrapper.isStrict()) {
                point.setX(point.getX() + basicDimension.getPoint().getX() + basicDimension.getWidth());
                point.setY(point.getY() + basicDimension.getPoint().getY());
            } else {
                point.setX(point.getX() + basicDimension.getPoint().getX() + basicDimension.getWidth());
            }
        }
        return dimension;
    }

    private Dimension doCalRelativeLeft(Graphics2D g, int canvasHeight, ElementWrapper elementWrapper, Dimension basicDimension) {
        AbstractElement element = elementWrapper.getElement();
        int relativeHeight = elementWrapper.isStrict() ? basicDimension.getHeight() : canvasHeight;
        Dimension dimension = element.calculateDimension(g, basicDimension.getPoint().getX(), relativeHeight);
        Position position = element.getPosition();
        if (position instanceof RelativePosition) {
            CoordinatePoint point = dimension.getPoint();
            if (elementWrapper.isStrict()) {
                point.setY(point.getY() + basicDimension.getPoint().getY());
            }
        }
        return dimension;
    }

    private Dimension doCalRelativeTop(Graphics2D g, int canvasWidth, ElementWrapper elementWrapper, Dimension basicDimension) {
        AbstractElement element = elementWrapper.getElement();
        int relativeWidth = elementWrapper.isStrict() ? basicDimension.getWidth() : canvasWidth;
        Dimension dimension = element.calculateDimension(g, relativeWidth, basicDimension.getPoint().getY());
        Position position = element.getPosition();
        if (position instanceof RelativePosition) {
            CoordinatePoint point = dimension.getPoint();
            if (elementWrapper.isStrict()) {
                point.setX(point.getX() + basicDimension.getPoint().getX());
            }
        }
        return dimension;
    }

    private Dimension doCalRelativeBottom(Graphics2D g, int canvasWidth, int canvasHeight, ElementWrapper elementWrapper, Dimension basicDimension) {
        AbstractElement element = elementWrapper.getElement();
        int relativeWidth = elementWrapper.isStrict() ? basicDimension.getWidth() : canvasWidth;
        int relativeHeight = canvasHeight - basicDimension.getHeight() - basicDimension.getPoint().getY();
        Dimension dimension = element.calculateDimension(g, relativeWidth, relativeHeight);
        Position position = element.getPosition();
        if (position instanceof RelativePosition) {
            CoordinatePoint point = dimension.getPoint();
            if (elementWrapper.isStrict()) {
                point.setX(point.getX() + basicDimension.getPoint().getX());
                point.setY(point.getY() + basicDimension.getPoint().getY() + basicDimension.getHeight());
            } else {
                point.setY(point.getY() + basicDimension.getPoint().getY() + basicDimension.getHeight());
            }
        }
        return dimension;
    }

    private Dimension calculateBoundingBox(Map<AbstractElement, Dimension> dimensionMap) {
        ArrayList<CoordinatePoint> points = new ArrayList<CoordinatePoint>();
        dimensionMap.forEach((k, v) -> {
            CoordinatePoint point = v.getPoint();
            int startX = point.getX();
            int startY = point.getY();
            points.add(CoordinatePoint.of(startX, startY));
            points.add(CoordinatePoint.of(startX + v.getWidth(), startY));
            points.add(CoordinatePoint.of(startX, startY + v.getHeight()));
            points.add(CoordinatePoint.of(startX + v.getWidth(), startY + v.getHeight()));
        });
        Dimension dimension = PointUtils.boundingBox(points);
        CoordinatePoint markPoint = dimension.getPoint();
        dimensionMap.forEach((k, v) -> {
            CoordinatePoint point = v.getPoint();
            int xOffset = point.getX() - markPoint.getX();
            int yOffset = point.getY() - markPoint.getY();
            PointOffset pointOffset = new PointOffset(xOffset, yOffset);
            this.pointOffsetMap.put((AbstractElement)k, pointOffset);
        });
        return dimension;
    }

    @Override
    public CoordinatePoint doRender(Graphics2D g, Dimension dimension, int canvasWidth, int canvasHeight) {
        Dimension basicDimension = this.dimensionMap.get(this.basicElement);
        if (this.getPosition() != null) {
            CoordinatePoint markPoint = this.getPosition().calculate(canvasWidth, canvasHeight, dimension.getWidth(), dimension.getHeight());
            CoordinatePoint point = basicDimension.getPoint();
            point.setX(markPoint.getX() + this.pointOffsetMap.get(this.basicElement).xOffset);
            point.setY(markPoint.getY() + this.pointOffsetMap.get(this.basicElement).yOffset);
            this.basicElement.beforeRender(g);
            this.basicElement.doRender(g, basicDimension, basicDimension.getWidth(), basicDimension.getHeight());
            for (ElementWrapper elementWrapper : this.elementWrapper) {
                AbstractElement element = elementWrapper.getElement();
                Dimension elementDimension = this.dimensionMap.get(element);
                CoordinatePoint elementPoint = elementDimension.getPoint();
                elementPoint.setX(markPoint.getX() + this.pointOffsetMap.get(element).xOffset);
                elementPoint.setY(markPoint.getY() + this.pointOffsetMap.get(element).yOffset);
                element.beforeRender(g);
                element.doRender(g, elementDimension, basicDimension.getWidth(), basicDimension.getHeight());
                element.afterRender(g);
            }
            return null;
        }
        this.basicElement.beforeRender(g);
        CoordinatePoint basicPoint = this.basicElement.doRender(g, basicDimension, canvasWidth, canvasHeight);
        for (ElementWrapper elementWrapper : this.elementWrapper) {
            AbstractElement element = elementWrapper.getElement();
            element.beforeRender(g);
            element.doRender(g, this.dimensionMap.get(element), basicDimension.getWidth(), basicDimension.getHeight());
            element.afterRender(g);
        }
        return basicPoint;
    }

    @Override
    public void beforeRender(Graphics2D g) {
        super.beforeRender(g);
        this.basicElement.beforeRender(g);
    }

    @Override
    public void afterRender(Graphics2D g) {
        super.afterRender(g);
        this.basicElement.afterRender(g);
    }

    private static class ElementWrapper {
        private AbstractElement element;
        private RelativeDirection direction;
        private boolean strict;
        private boolean follow;

        public ElementWrapper(AbstractElement element) {
            this.element = element;
        }

        public ElementWrapper(AbstractElement element, RelativeDirection direction, boolean strict, boolean follow) {
            this.element = element;
            this.direction = direction;
            this.strict = strict;
            this.follow = follow;
        }

        public AbstractElement getElement() {
            return this.element;
        }

        public RelativeDirection getDirection() {
            return this.direction;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public boolean isFollow() {
            return this.follow;
        }

        public void setElement(AbstractElement element) {
            this.element = element;
        }

        public void setDirection(RelativeDirection direction) {
            this.direction = direction;
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
        }

        public void setFollow(boolean follow) {
            this.follow = follow;
        }
    }

    private static class PointOffset {
        private final int xOffset;
        private final int yOffset;

        public PointOffset(int x, int y) {
            this.xOffset = x;
            this.yOffset = y;
        }
    }
}

