/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas.element;

import com.augrain.easy.canvas.element.IElement;
import com.augrain.easy.canvas.element.advance.ComposeElement;
import com.augrain.easy.canvas.exception.CanvasException;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.geometry.Dimension;
import com.augrain.easy.canvas.geometry.Position;
import com.augrain.easy.canvas.model.Gradient;
import com.augrain.easy.canvas.model.RelativeDirection;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;

public abstract class AbstractElement<T extends AbstractElement>
implements IElement {
    protected float alpha = 1.0f;
    protected int rotate = 0;
    protected Position position;
    protected Gradient gradient;

    public T setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new CanvasException("alpha must be between 0 and 1");
        }
        this.alpha = alpha;
        return (T)this;
    }

    public T setRotate(int rotate) {
        this.rotate = rotate;
        return (T)this;
    }

    public T setPosition(Position position) {
        this.position = position;
        return (T)this;
    }

    public T setGradient(Gradient gradient) {
        this.gradient = gradient;
        return (T)this;
    }

    public ComposeElement follow(AbstractElement element, RelativeDirection direction, boolean strict) {
        ComposeElement composeElement = ComposeElement.of(this);
        composeElement.follow(element, direction, strict);
        return composeElement;
    }

    @Override
    public CoordinatePoint render(Graphics2D g, int canvasWidth, int canvasHeight) throws Exception {
        this.beforeRender(g);
        Dimension elementInfo = this.calculateDimension(g, canvasWidth, canvasHeight);
        CoordinatePoint coordinatePoint = this.doRender(g, elementInfo, canvasWidth, canvasHeight);
        this.afterRender(g);
        return coordinatePoint;
    }

    public abstract Dimension calculateDimension(Graphics2D var1, int var2, int var3);

    public abstract CoordinatePoint doRender(Graphics2D var1, Dimension var2, int var3, int var4);

    public void beforeRender(Graphics2D g) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.alpha);
        g.setComposite(alphaComposite);
    }

    public void afterRender(Graphics2D g) {
    }

    public void gradient(Graphics2D g, Dimension dimension) {
        if (this.gradient != null) {
            g.setPaint(this.gradient.toGradient(dimension));
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getRotate() {
        return this.rotate;
    }

    public Position getPosition() {
        return this.position;
    }

    public Gradient getGradient() {
        return this.gradient;
    }
}

