/*
 * Decompiled with CFR 0.152.
 */
package com.augrain.easy.canvas;

import com.augrain.easy.canvas.element.IElement;
import com.augrain.easy.canvas.element.basic.CircleElement;
import com.augrain.easy.canvas.element.basic.ImageElement;
import com.augrain.easy.canvas.element.basic.LineElement;
import com.augrain.easy.canvas.element.basic.RectangleElement;
import com.augrain.easy.canvas.element.basic.TextElement;
import com.augrain.easy.canvas.exception.CanvasException;
import com.augrain.easy.canvas.geometry.CoordinatePoint;
import com.augrain.easy.canvas.model.CanvasListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class EasyCanvas {
    private final List<IElement> renderedElements = new ArrayList<IElement>();
    private final int canvasWidth;
    private final int canvasHeight;
    private CanvasListener canvasListener;

    public EasyCanvas(int canvasWidth, int canvasHeight) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
    }

    public EasyCanvas(BufferedImage backgroundImg) {
        this.canvasWidth = backgroundImg.getWidth();
        this.canvasHeight = backgroundImg.getHeight();
        this.addImageElement(backgroundImg);
    }

    public void addElement(IElement element) {
        this.renderedElements.add(element);
    }

    public TextElement addTextElement(String text) {
        TextElement textElement = new TextElement(text);
        this.renderedElements.add(textElement);
        return textElement;
    }

    public ImageElement addImageElement(BufferedImage input) {
        ImageElement textElement = new ImageElement(input);
        this.renderedElements.add(textElement);
        return textElement;
    }

    public RectangleElement addRectangleElement(int width, int height) {
        RectangleElement rectElement = new RectangleElement(width, height);
        this.renderedElements.add(rectElement);
        return rectElement;
    }

    public CircleElement addCircleElement(int radius) {
        CircleElement circleElement = new CircleElement(radius);
        this.renderedElements.add(circleElement);
        return circleElement;
    }

    public CircleElement addOvalElement(int width, int height) {
        CircleElement circleElement = new CircleElement(width, height);
        this.renderedElements.add(circleElement);
        return circleElement;
    }

    public LineElement addLineElement(CoordinatePoint start, CoordinatePoint end) {
        LineElement lineElement = new LineElement(start, end);
        this.renderedElements.add(lineElement);
        return lineElement;
    }

    private BufferedImage render() throws Exception {
        BufferedImage baseImg = new BufferedImage(this.canvasWidth, this.canvasHeight, 2);
        Graphics2D g = baseImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        for (IElement element : this.renderedElements) {
            element.render(g, this.canvasWidth, this.canvasHeight);
        }
        g.dispose();
        return baseImg;
    }

    public void asFile(String format, String filePath) {
        try {
            BufferedImage image = this.render();
            if (this.canvasListener != null) {
                image = this.canvasListener.beforeOut(image);
            }
            ImageIO.write((RenderedImage)image, format, new File(filePath));
        }
        catch (Exception e) {
            throw new CanvasException(e);
        }
    }

    public byte[] asBytes(String format) {
        try {
            BufferedImage image = this.render();
            if (this.canvasListener != null) {
                image = this.canvasListener.beforeOut(image);
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, format, output);
            return output.toByteArray();
        }
        catch (Exception e) {
            throw new CanvasException(e);
        }
    }

    public void setCanvasListener(CanvasListener canvasListener) {
        this.canvasListener = canvasListener;
    }
}

