/*
 * Decompiled with CFR 0.152.
 */
package cn.asens.util;

import cn.asens.util.PropertyUtils;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountUtils {
    public static Map<String, String> makeUrlMap() {
        try {
            return PropertyUtils.getConfigMap(Thread.currentThread().getContextClassLoader().getResourceAsStream("config/urlmap.ini"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String parseReferer(String referer, Map<String, String> urlMap) {
        String protocol;
        if (referer == null) {
            return null;
        }
        String refererName = referer;
        String string = protocol = referer.startsWith("https") ? "https" : "http";
        if (!"".equals(refererName)) {
            referer = referer.substring(referer.indexOf(protocol) + protocol.length() + 3);
            if ((referer = referer.substring(referer.indexOf("/"))).contains("?")) {
                referer = referer.substring(0, referer.lastIndexOf("?"));
            }
            if ((refererName = CountUtils.parseUri(referer, urlMap)) == null || "".equals(refererName)) {
                refererName = referer;
            }
        }
        return refererName;
    }

    public static String parseUri(String uri, Map<String, String> urlMap) {
        String key;
        for (Map.Entry<String, String> entry : urlMap.entrySet()) {
            key = entry.getKey();
            if (!uri.equals(key)) continue;
            return entry.getValue();
        }
        for (Map.Entry<String, String> entry : urlMap.entrySet()) {
            key = entry.getKey();
            if (!uri.matches(key)) continue;
            return entry.getValue();
        }
        return null;
    }
}

