package cn.asens.util;

import java.util.Map;

/**
 * @author Asens
 */

public class CountUtils {

    public static Map<String, String> makeUrlMap() {
        try {
            return PropertyUtils.getConfigMap(Thread.currentThread()
                    .getContextClassLoader()
                    .getResourceAsStream("config/urlmap.ini"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String parseReferer(String referer,Map<String,String> urlMap) {
        if(referer==null){
            return null;
        }
        String refererName=referer;
        String protocol=referer.startsWith("https")?"https":"http";
        if(!"".equals(refererName)){
            referer=referer.substring(referer.indexOf(protocol)+protocol.length()+3);
            referer=referer.substring(referer.indexOf("/"));
            if(referer.contains("?")) {
                referer = referer.substring(0, referer.lastIndexOf("?"));
            }
            refererName=parseUri(referer,urlMap);
            if(refererName==null||"".equals(refererName)){
                refererName=referer;
            }
        }
        return refererName;
    }



    public static String parseUri(String uri,Map<String,String> urlMap) {
        for(Map.Entry<String,String> entry:urlMap.entrySet()){
            String key=entry.getKey();
            if(uri.equals(key)){
                return entry.getValue();
            }
        }
        for(Map.Entry<String,String> entry:urlMap.entrySet()){
            String key=entry.getKey();
            if(uri.matches(key)){
                return entry.getValue();
            }
        }
        return null;
    }
}
