package cn.asens.filter;

/**
 * 提供一种机制对生成的JSON进行统一的处理.
 * 可以统一设置appId，username或是url等
 * 在系统初始化的时候使用Count.addFilter()给Count设置各种Filter
 * Spring体系下可以使用PostConstruct注解
 * 在发送日志前会按照顺序进行处理
 * 会传递当前发送的API接口，可以只针对某种的接口处理，如：
 * if(!Count.API_VIEW_LOG.equals(api)){
 *     return source;
 * }
 * return doSomething(source);
 *
 * 注意各种不同的接口json结构不同
 *
 * @author Asens
 */

public interface CountFilter {

    /**
     * @param source 当前的json
     * @param api 要调用的接口的api 如 Count.API_VIEW_LOG,api为空或null全部拦截
     * @return 处理后的JSON
     */
    String handle(String source,String api);
}
