package cn.asens;

import cn.asens.entity.*;
import cn.asens.filter.CountFilter;
import cn.asens.util.PropertyUtils;
import cn.asens.util.https.HttpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author Asens
 */

public class Count {
    private static Logger log=LoggerFactory.getLogger(Count.class);

    private final static ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool
            (Runtime.getRuntime().availableProcessors());

    private static String countHost=PropertyUtils
            .getProperty("/config/count_config.ini","countHost");

    private static String appId=PropertyUtils
            .getProperty("/config/count_config.ini","appId");

    private static List<CountFilter> filterList=new ArrayList<CountFilter>();

    public final static String API_VIEW_LOG = "/viewLog";
    public final static String API_ORDER = "/order";
    public final static String API_RESOURCE = "/resource";
    public final static String API_USER = "/userInfo";
    public final static String API_PERFORMANCE = "/performance";
    public final static String API_INSTITUTION = "/institution";
    public final static String API_RESOURCE_CAT = "/resource/cat";

    public final static String API_INSTITUTION_DATA = "/institutionData";


    public final static String API_ORDERS = "/orders";
    public final static String API_RESOURCES = "/resources";
    public final static String API_USERS = "/userInfos";

    public static void asyncViewLog(ViewLog viewLog) {
        EXECUTOR_SERVICE.execute(new MessageTask(viewLog, API_VIEW_LOG));
    }

    public static void asyncResource(Resource resource) {
        EXECUTOR_SERVICE.execute(new MessageTask(resource, API_RESOURCE));
    }

    public static void asyncOrder(CountUserOrder countUserOrder) {
        EXECUTOR_SERVICE.execute(new MessageTask(countUserOrder, API_ORDER));
    }

    public static void asyncUser(CountUser countUser) {
        EXECUTOR_SERVICE.execute(new MessageTask(countUser, API_USER));
    }

    public static void asyncInstitution(Institution institution) {
        EXECUTOR_SERVICE.execute(new MessageTask(institution, API_INSTITUTION));
    }

    public void asyncResourceCat(JSONObject object) {
        EXECUTOR_SERVICE.execute(new MessageTask(object, API_RESOURCE_CAT));
    }

    public static boolean syncOrders(List<CountUserOrder> orderList) {
        return syncList(orderList, API_ORDERS);
    }

    public static boolean syncUsers(List<CountUser> countUserList) {
        return syncList(countUserList, API_USERS);
    }

    public static boolean syncResources(List<Resource> resourceList) {
        return syncList(resourceList, API_RESOURCES);
    }

    public static String institutionData(String json) {
        return HttpUtils.doPost(countHost + API_INSTITUTION_DATA, json);
    }

    public static String appId() {
        return appId;
    }

    public static String host() {
        return countHost;
    }

    public static void setCountHost(String countHost) {
        Count.countHost = countHost;
    }

    public static void setAppId(String appId) {
        Count.appId = appId;
    }

    private static class MessageTask extends Thread {
        private Object o;
        private String api;

        private MessageTask(Object o, String api) {
            this.o = o;
            this.api = api;
            init();
        }

        private void init() {
            String json = JSON.toJSONString(o);
            JSONObject t = JSON.parseObject(json);
            if(t.get("appId")==null){
                t.put("appId", appId);
            }
            json = t.toJSONString();
            for(CountFilter filter:filterList){
                json=filter.handle(json,api);
            }
            o=JSON.parse(json);
        }

        @Override
        public void run() {
            try {
                String result = syncEntity(o, api);
                log.info("MessageTask result:" + result);
            } catch (Exception e) {
                log.error("MessageTask error:" + e.getMessage());
            }

        }
    }

    private static String syncEntity(Object o, String api) {
        log.debug("countHost + api : "+(countHost + api));
        return HttpUtils.doPost(countHost + api, JSON.toJSONString(o));
    }

    private static boolean syncList(List<?> list, String api) {
        try {
            String json = JSON.toJSONString(list);
            JSONArray array = JSON.parseArray(json);
            for (int i = 0, l = array.size(); i < l; i++) {
                JSONObject t = JSON.parseObject(array.get(i).toString());
                if(t.get("appId")==null){
                    t.put("appId", appId);
                }
                String tJson=t.toJSONString();
                for(CountFilter filter:filterList){
                    tJson=filter.handle(tJson,api);
                }
                array.set(i,tJson);
            }
            String result=HttpUtils.doPost(countHost + api, array.toJSONString());
            return "success".equals(result);
        } catch (Exception e) {
            return false;
        }
    }

    public static void addFilter(CountFilter countFilter){
        filterList.add(countFilter);
    }

}
