/*
 * Decompiled with CFR 0.152.
 */
package cn.asens.util.https;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static DefaultHttpClient httpClient = null;
    private static final Object syncLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DefaultHttpClient getHttpClient(String url) {
        String hostname = url.split("/")[2];
        int port = 80;
        if (hostname.contains(":")) {
            String[] arr = hostname.split(":");
            hostname = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        if (httpClient == null) {
            Object object = syncLock;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpUtils.createHttpClient(200, 40, 100, hostname, port);
                }
            }
        }
        return httpClient;
    }

    private static DefaultHttpClient createHttpClient(int maxTotal, int maxPerRoute, int maxRoute, String hostname, int port) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager(schemeRegistry);
        ccm.setDefaultMaxPerRoute(maxPerRoute);
        ccm.setMaxTotal(maxTotal);
        HttpHost httpHost = new HttpHost(hostname, port);
        ccm.setMaxForRoute(new HttpRoute(httpHost), maxRoute);
        return new DefaultHttpClient((ClientConnectionManager)ccm);
    }

    public static String doPost(String url, String json) {
        HttpPost httppost = new HttpPost(url);
        String result = null;
        try {
            StringEntity s = new StringEntity(json, "UTF-8");
            s.setContentType("application/json");
            httppost.setEntity((HttpEntity)s);
            CloseableHttpResponse response = HttpUtils.getHttpClient(url).execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            EntityUtils.consume((HttpEntity)entity);
            return result;
        }
        catch (IOException e) {
            return "sent message to Count failed, IOException : " + e.getMessage();
        }
    }
}

